/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.sources;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.NumberUtils;
import org.configureme.repository.ConfigurationRepository;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSource {
    private ConfigurationSourceKey key;
    private List<ConfigurationSourceListener> listeners;
    private long lastChangeTimestamp;
    private static Logger log = LoggerFactory.getLogger(ConfigurationSource.class);

    public ConfigurationSource(ConfigurationSourceKey aKey) {
        this.key = aKey;
        this.listeners = new ArrayList<ConfigurationSourceListener>();
        this.lastChangeTimestamp = System.currentTimeMillis();
        this.listeners.add(ConfigurationRepository.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationSourceListener listener) {
        List<ConfigurationSourceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigurationSourceListener listener) {
        List<ConfigurationSourceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public String toString() {
        return "ConfigurationSource " + this.key + ", listeners: " + this.listeners.size() + ", " + NumberUtils.makeISO8601TimestampString((long)this.getLastChangeTimestamp());
    }

    public long getLastChangeTimestamp() {
        return this.lastChangeTimestamp;
    }

    public ConfigurationSourceKey getKey() {
        return this.key;
    }

    public boolean isOlderAs(long sourceChangeTimestamp) {
        return this.lastChangeTimestamp < sourceChangeTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUpdateEvent(long timestamp) {
        List<ConfigurationSourceListener> list = this.listeners;
        synchronized (list) {
            for (ConfigurationSourceListener listener : this.listeners) {
                try {
                    log.debug("Calling configurationSourceUpdated on " + listener);
                    listener.configurationSourceUpdated(this);
                }
                catch (Exception e) {
                    log.error("Error in notifying configuration source listener:" + listener, (Throwable)e);
                }
            }
        }
        this.lastChangeTimestamp = timestamp;
    }
}

