/*
 * Decompiled with CFR 0.152.
 */
package org.configureme.sources;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.util.NumberUtils;
import org.configureme.ConfigurableWrapper;
import org.configureme.sources.ConfigurationSource;
import org.configureme.sources.ConfigurationSourceKey;
import org.configureme.sources.ConfigurationSourceListener;
import org.configureme.sources.FileLoader;
import org.configureme.sources.SourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigurationSourceRegistry {
    INSTANCE;

    private static Logger log;
    private Map<ConfigurationSourceKey, ConfigurationSource> watchedSources = new ConcurrentHashMap<ConfigurationSourceKey, ConfigurationSource>();
    private Map<ConfigurationSourceKey.Type, SourceLoader> loaders = new ConcurrentHashMap<ConfigurationSourceKey.Type, SourceLoader>();

    private ConfigurationSourceRegistry() {
        this.initLoaders();
        new WatcherThread().start();
    }

    private void initLoaders() {
        this.loaders.clear();
        this.loaders.put(ConfigurationSourceKey.Type.FILE, new FileLoader());
    }

    public boolean isConfigurationAvailable(ConfigurationSourceKey key) {
        if (this.watchedSources.containsKey(key)) {
            return true;
        }
        SourceLoader loader = this.loaders.get((Object)key.getType());
        if (loader == null) {
            throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)key.getType()));
        }
        return loader.isAvailable(key);
    }

    public String readConfigurationSource(ConfigurationSourceKey key) {
        SourceLoader loader = this.loaders.get((Object)key.getType());
        if (loader == null) {
            throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)key.getType()));
        }
        return loader.getContent(key);
    }

    public Set<ConfigurationSourceKey> getAllSourceKeys() {
        return this.watchedSources.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigurationSourceKey key, ConfigurationSourceListener listener) {
        ConfigurationSource source = this.watchedSources.get(key);
        if (source == null) {
            Map<ConfigurationSourceKey, ConfigurationSource> map = this.watchedSources;
            synchronized (map) {
                source = this.watchedSources.get(key);
                if (source == null) {
                    source = new ConfigurationSource(key);
                    this.watchedSources.put(key, source);
                }
            }
        }
        source.addListener(listener);
    }

    public void removeListener(ConfigurationSourceKey key, ConfigurationSourceListener listener) {
        ConfigurationSource source = this.watchedSources.get(key);
        if (source == null) {
            return;
        }
        source.removeListener(listener);
    }

    public void removeWatchedConfigurable(ConfigurableWrapper wrapper) {
        this.removeListener(wrapper.getKey(), wrapper);
    }

    public void addWatchedConfigurable(ConfigurableWrapper wrapper) {
        if (wrapper.getConfigurable() == null) {
            throw new AssertionError((Object)"configurable is null");
        }
        ConfigurationSourceKey key = wrapper.getKey();
        this.addListener(key, wrapper);
    }

    protected void addLoader(ConfigurationSourceKey.Type type, SourceLoader loader) {
        this.loaders.put(type, loader);
    }

    void reset() {
        this.watchedSources = new ConcurrentHashMap<ConfigurationSourceKey, ConfigurationSource>();
        this.initLoaders();
    }

    static {
        log = LoggerFactory.getLogger(ConfigurationSourceRegistry.class);
    }

    private final class WatcherThread
    extends Thread {
        private WatcherThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Thread.sleep(10000L);
                    Collection allSources = ConfigurationSourceRegistry.this.watchedSources.values();
                    for (ConfigurationSource source : allSources) {
                        SourceLoader loader = (SourceLoader)ConfigurationSourceRegistry.this.loaders.get((Object)source.getKey().getType());
                        try {
                            long lastUpdate = loader.getLastChangeTimestamp(source.getKey());
                            log.debug("Checking source: " + source + ", lastUpdateFromLoader= " + NumberUtils.makeISO8601TimestampString((long)lastUpdate) + ", storedLastUpdate=" + NumberUtils.makeISO8601TimestampString((long)source.getLastChangeTimestamp()));
                            if (!source.isOlderAs(lastUpdate)) continue;
                            log.debug("firing update event: " + source);
                            source.fireUpdateEvent(lastUpdate);
                        }
                        catch (IllegalArgumentException e) {
                            log.warn("Apparently checking for non existing source, how did it came into the registry anyway?", (Throwable)e);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

