/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class BigDecimalConverter
implements Converter {
    public static final BigDecimalConverter INSTANCE = new BigDecimalConverter();

    BigDecimalConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return BigDecimal.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof String) {
            String str;
            NumberFormat f = context.getNumberFormat();
            if (f != null) {
                value = f.parse((String)value);
            }
            if ((str = value.toString().trim()).length() > 0) {
                if (str.charAt(0) == '+') {
                    return new BigDecimal(str.substring(1));
                }
                return new BigDecimal(str);
            }
            return null;
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

