/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.sessions;

import java.util.Optional;
import java.util.Random;
import net.jqwik.api.FacadeLoader;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;

@API(status=API.Status.MAINTAINED, since="1.8.0")
public class JqwikSession {
    public static synchronized void start() {
        JqwikSessionFacade.implementation.startSession(null);
    }

    public static boolean isActive() {
        return JqwikSessionFacade.implementation.isSessionOpen();
    }

    public static synchronized void finish() {
        JqwikSessionFacade.implementation.finishSession();
    }

    public static synchronized void finishTry() {
        JqwikSessionFacade.implementation.finishTry();
    }

    public static synchronized void run(Runnable runnable) {
        JqwikSessionFacade.implementation.runInSession(null, runnable);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9.1")
    public static Optional<Random> getRandom() {
        return JqwikSessionFacade.implementation.getRandom();
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9.1")
    public static void start(String randomSeed) {
        JqwikSessionFacade.implementation.startSession(randomSeed);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.9.1")
    public static void run(String randomSeed, Runnable runnable) {
        JqwikSessionFacade.implementation.runInSession(randomSeed, runnable);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class JqwikSessionFacade {
        private static final JqwikSessionFacade implementation = FacadeLoader.load(JqwikSessionFacade.class);

        public abstract void finishSession();

        public abstract void finishTry();

        public abstract boolean isSessionOpen();

        public abstract void runInSession(@Nullable String var1, Runnable var2);

        public abstract Optional<Random> getRandom();

        public abstract void startSession(@Nullable String var1);
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run() throws Throwable;
    }
}

