/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Reporter;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.execution.LifecycleContextSupport;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;

abstract class AbstractLifecycleContext
implements LifecycleContext {
    private Reporter reporter;
    private final TestDescriptor descriptor;

    protected AbstractLifecycleContext(Reporter reporter, TestDescriptor descriptor) {
        this.reporter = reporter;
        this.descriptor = descriptor;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public void wrapReporter(Function<Reporter, Reporter> wrapper) {
        this.reporter = wrapper.apply(this.reporter);
    }

    public String label() {
        return this.descriptor.getDisplayName();
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationClass) {
        return this.optionalElement().flatMap(element -> AnnotationSupport.findAnnotation((AnnotatedElement)element, (Class)annotationClass));
    }

    public <A extends Annotation> List<A> findAnnotationsInContainer(Class<A> annotationClass) {
        return this.optionalElement().map(element -> {
            ArrayList annotations = new ArrayList();
            this.appendAnnotations(this.parentContainer(), annotationClass, annotations);
            return annotations;
        }).orElse(Collections.emptyList());
    }

    public <T extends Annotation> List<T> findRepeatableAnnotations(Class<T> annotationClass) {
        return AnnotationSupport.findRepeatableAnnotations((Optional)this.optionalElement(), annotationClass);
    }

    private Optional<ContainerClassDescriptor> parentContainer() {
        return this.parentContainer(this.descriptor);
    }

    private Optional<ContainerClassDescriptor> parentContainer(TestDescriptor descriptor) {
        return descriptor.getParent().filter(parent -> parent instanceof ContainerClassDescriptor).map(parent -> (ContainerClassDescriptor)parent);
    }

    private <T extends Annotation> void appendAnnotations(Optional<ContainerClassDescriptor> optionalContainer, Class<T> annotationClass, List<T> annotations) {
        optionalContainer.ifPresent(container -> {
            annotations.addAll(JqwikAnnotationSupport.findContainerAnnotations(container.getContainerClass(), annotationClass));
            this.appendAnnotations(this.parentContainer((TestDescriptor)container), annotationClass, annotations);
        });
    }

    protected String toString(Class<? extends LifecycleContext> contextType) {
        String uniqueIdDescription = LifecycleContextSupport.formatUniqueId(this.descriptor.getUniqueId());
        return String.format("%s(%s)", contextType.getSimpleName(), uniqueIdDescription);
    }
}

