/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.Optional;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.ValueReport;

class CircularDependencyReport
extends ValueReport {
    private final Object value;

    CircularDependencyReport(Optional<String> label, Object value) {
        super(label);
        this.value = value;
    }

    @Override
    public String singleLineReport() {
        return String.format("circular-dependency<%s@%s>", this.label.orElse(this.value.getClass().getName()), System.identityHashCode(this.value));
    }

    @Override
    public void report(LineReporter lineReporter, int indentLevel, String appendix) {
        lineReporter.addLine(indentLevel, this.singleLineReport() + appendix);
    }
}

