/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.Tuple;
import net.jqwik.engine.execution.reporting.CircularDependencyReport;
import net.jqwik.engine.execution.reporting.CollectionValueReport;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.MapValueReport;
import net.jqwik.engine.execution.reporting.NullReportingFormat;
import net.jqwik.engine.execution.reporting.ObjectValueReport;
import net.jqwik.engine.execution.reporting.SampleReportingFormats;
import net.jqwik.engine.execution.reporting.TupleValueReport;

public abstract class ValueReport {
    final Optional<String> label;

    static ValueReport of(Object value) {
        return ValueReport.of(value, SampleReportingFormats.getReportingFormats());
    }

    public static ValueReport of(Object value, Collection<SampleReportingFormat> availableFormats) {
        ReportingFormatFinder formatFinder = ValueReport.formatFinder(availableFormats);
        return ValueReport.of(value, formatFinder);
    }

    private static ValueReport of(Object value, ReportingFormatFinder formatFinder) {
        Set<Object> visited = ValueReport.visitedSet(Collections.emptySet());
        return ValueReport.of(value, formatFinder, visited);
    }

    private static Set<Object> visitedSet(Set<Object> from) {
        Set<Object> objects = Collections.newSetFromMap(new IdentityHashMap());
        objects.addAll(from);
        return objects;
    }

    private static ValueReport of(Object value, ReportingFormatFinder formatFinder, Set<Object> visited) {
        SampleReportingFormat format = formatFinder.find(value);
        if (visited.contains(value)) {
            return new CircularDependencyReport(format.label(value), value);
        }
        visited.add(value);
        Object reportedValue = format.report(value);
        if (reportedValue instanceof Collection) {
            return ValueReport.createCollectionReport(format.label(value), (Collection)reportedValue, formatFinder, visited);
        }
        if (reportedValue instanceof Map) {
            return ValueReport.createMapReport(format.label(value), (Map)reportedValue, formatFinder, visited);
        }
        if (reportedValue instanceof Tuple) {
            return ValueReport.createTupleReport(format.label(value), (Tuple)reportedValue, formatFinder, visited);
        }
        visited.remove(value);
        return new ObjectValueReport(format.label(value), reportedValue);
    }

    private static ValueReport createTupleReport(Optional<String> label, Tuple tuple, ReportingFormatFinder formatFinder, Set<Object> visited) {
        List<ValueReport> tupleReports = tuple.items().stream().map(value -> ValueReport.of(value, formatFinder, ValueReport.visitedSet(visited))).collect(Collectors.toList());
        return new TupleValueReport(label, tupleReports);
    }

    private static ValueReport createMapReport(Optional<String> label, Map<Object, Object> map, ReportingFormatFinder formatFinder, Set<Object> visited) {
        List<Map.Entry<ValueReport, ValueReport>> reportEntries = map.entrySet().stream().map(entry -> {
            final ValueReport keyReport = ValueReport.of(entry.getKey(), formatFinder, ValueReport.visitedSet(visited));
            final ValueReport valueReport = ValueReport.of(entry.getValue(), formatFinder, ValueReport.visitedSet(visited));
            return new Map.Entry<ValueReport, ValueReport>(){

                @Override
                public ValueReport getKey() {
                    return keyReport;
                }

                @Override
                public ValueReport getValue() {
                    return valueReport;
                }

                @Override
                public ValueReport setValue(ValueReport value) {
                    throw new UnsupportedOperationException();
                }
            };
        }).collect(Collectors.toList());
        return new MapValueReport(label, reportEntries);
    }

    private static ValueReport createCollectionReport(Optional<String> label, Collection<Object> collection, ReportingFormatFinder formatFinder, Set<Object> visited) {
        List<ValueReport> reportCollection = collection.stream().map(element -> ValueReport.of(element, formatFinder, ValueReport.visitedSet(visited))).collect(Collectors.toList());
        return new CollectionValueReport(label, reportCollection);
    }

    private static ReportingFormatFinder formatFinder(Collection<SampleReportingFormat> unsortedFormats) {
        ArrayList<SampleReportingFormat> formats = new ArrayList<SampleReportingFormat>(unsortedFormats);
        Collections.sort(formats);
        return targetValue -> formats.stream().filter(format -> {
            try {
                return format.appliesTo(targetValue);
            }
            catch (NullPointerException npe) {
                return false;
            }
        }).findFirst().orElse(new NullReportingFormat());
    }

    protected ValueReport(Optional<String> label) {
        this.label = label;
    }

    int singleLineLength() {
        return this.singleLineReport().length();
    }

    public abstract String singleLineReport();

    public abstract void report(LineReporter var1, int var2, String var3);

    static interface ReportingFormatFinder {
        public SampleReportingFormat find(Object var1);
    }
}

