/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.jqwik.api.RandomDistribution;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.randomized.BiasedPartitionPointsCalculator;

class BiasedNumericGenerator
implements RandomDistribution.RandomNumericGenerator {
    private final RandomDistribution.RandomNumericGenerator partitionedGenerator;

    BiasedNumericGenerator(int genSize, BigInteger min, BigInteger max, BigInteger center) {
        List<BigInteger> partitionPoints = BiasedPartitionPointsCalculator.calculatePartitionPoints(genSize, min, max, center);
        Range<BigInteger> range = Range.of(min, max);
        this.partitionedGenerator = this.partitionedGenerator(range, partitionPoints);
    }

    public BigInteger next(Random random) {
        return this.partitionedGenerator.next(random);
    }

    private RandomDistribution.RandomNumericGenerator partitionedGenerator(Range<BigInteger> range, List<BigInteger> partitionPoints) {
        if (partitionPoints.isEmpty()) {
            return this.createUniformGenerator((BigInteger)range.min, (BigInteger)range.max);
        }
        List<RandomDistribution.RandomNumericGenerator> generators = this.createPartitions(range, partitionPoints);
        return random -> ((RandomDistribution.RandomNumericGenerator)generators.get(random.nextInt(generators.size()))).next(random);
    }

    private List<RandomDistribution.RandomNumericGenerator> createPartitions(Range<BigInteger> range, List<BigInteger> partitionPoints) {
        ArrayList<RandomDistribution.RandomNumericGenerator> partitions = new ArrayList<RandomDistribution.RandomNumericGenerator>();
        Collections.sort(partitionPoints);
        BigInteger lower = (BigInteger)range.min;
        for (BigInteger partitionPoint : partitionPoints) {
            BigInteger upper = partitionPoint;
            if (upper.compareTo(lower) <= 0) continue;
            if (upper.compareTo((BigInteger)range.max) >= 0) break;
            partitions.add(this.createUniformGenerator(lower, upper.subtract(BigInteger.ONE)));
            lower = upper;
        }
        partitions.add(this.createUniformGenerator(lower, (BigInteger)range.max));
        return partitions;
    }

    private RandomDistribution.RandomNumericGenerator createUniformGenerator(BigInteger minGenerate, BigInteger maxGenerate) {
        int ignoredGenSize = 1000;
        BigInteger ignoredCenter = minGenerate;
        return RandomDistribution.uniform().createGenerator(ignoredGenSize, minGenerate, maxGenerate, ignoredCenter);
    }
}

