/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.constraints.UniqueElements;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class UniqueElementsConfigurator
implements ArbitraryConfigurator {
    public <T> Arbitrary<T> configure(Arbitrary<T> arbitrary, TypeUsage targetType) {
        return targetType.findAnnotation(UniqueElements.class).map(uniqueness -> {
            if (arbitrary instanceof SetArbitrary) {
                return this.configureSetArbitrary((SetArbitrary)((SetArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (arbitrary instanceof StreamableArbitrary) {
                return this.configureStreamableArbitrary((StreamableArbitrary)((StreamableArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (targetType.isAssignableFrom(List.class)) {
                Arbitrary listArbitrary = arbitrary;
                return listArbitrary.filter(UniqueElementsConfigurator.isUnique(uniqueness));
            }
            if (targetType.isAssignableFrom(Set.class)) {
                Arbitrary setArbitrary = arbitrary;
                return setArbitrary.filter(UniqueElementsConfigurator.isUnique(uniqueness));
            }
            if (targetType.isArray()) {
                Arbitrary arrayArbitrary = arbitrary;
                Predicate predicate = UniqueElementsConfigurator.isUnique(uniqueness);
                return arrayArbitrary.filter(array -> predicate.test(Arrays.asList(array)));
            }
            if (targetType.isAssignableFrom(Stream.class)) {
                Arbitrary streamArbitrary = arbitrary;
                return streamArbitrary.map(s -> s.collect(Collectors.toList())).filter(UniqueElementsConfigurator.isUnique(uniqueness)).map(Collection::stream);
            }
            if (targetType.isAssignableFrom(Iterator.class)) {
                Arbitrary iteratorArbitrary = arbitrary;
                Arbitrary listArbitrary = iteratorArbitrary.map(this::toList);
                return listArbitrary.filter(UniqueElementsConfigurator.isUnique(uniqueness)).map(List::iterator);
            }
            return arbitrary;
        }).orElse(arbitrary);
    }

    private <T> List<T> toList(Iterator<T> i) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    private static <C extends Collection<?>> Predicate<C> isUnique(UniqueElements uniqueness) {
        Class extractorClass = uniqueness.by();
        if (extractorClass.equals(UniqueElements.NOT_SET.class)) {
            return items -> {
                Class<?> c = items.getClass();
                if (c.equals(HashSet.class) || c.equals(LinkedHashSet.class) || c.equals(ConcurrentHashMap.KeySetView.class) || c.equals(CopyOnWriteArraySet.class)) {
                    return true;
                }
                HashSet set = new HashSet();
                for (Object x : items) {
                    if (set.add(x)) continue;
                    return false;
                }
                return true;
            };
        }
        Function extractor = UniqueElementsConfigurator.extractor(extractorClass);
        return items -> {
            HashSet set = new HashSet();
            for (Object x : items) {
                if (set.add(extractor.apply(x))) continue;
                return false;
            }
            return true;
        };
    }

    private <T> Arbitrary<?> configureStreamableArbitrary(StreamableArbitrary<T, ?> arbitrary, UniqueElements uniqueness) {
        Class extractorClass = uniqueness.by();
        if (extractorClass.equals(UniqueElements.NOT_SET.class)) {
            return arbitrary.uniqueElements();
        }
        Function<T, Object> extractor = UniqueElementsConfigurator.extractor(extractorClass);
        return arbitrary.uniqueElements(extractor);
    }

    private <T> Arbitrary<?> configureSetArbitrary(SetArbitrary<T> arbitrary, UniqueElements uniqueness) {
        Class extractorClass = uniqueness.by();
        if (extractorClass.equals(UniqueElements.NOT_SET.class)) {
            return arbitrary;
        }
        Function<T, Object> extractor = UniqueElementsConfigurator.extractor(extractorClass);
        return arbitrary.uniqueElements(extractor);
    }

    private static <T> Function<T, Object> extractor(Class<? extends Function<?, ?>> extractorClass) {
        return extractorClass.equals(UniqueElements.NOT_SET.class) ? Function.identity() : JqwikReflectionSupport.newInstanceWithDefaultConstructor(extractorClass);
    }
}

