/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.jqwik.engine.support.JqwikStreamSupport;

public class AggressiveSizeOfListShrinker<T> {
    private final int minSize;

    public AggressiveSizeOfListShrinker(int minSize) {
        this.minSize = minSize;
    }

    public Stream<List<T>> shrink(List<? extends T> toShrink) {
        if (toShrink.size() <= this.minSize) {
            return Stream.empty();
        }
        return JqwikStreamSupport.concat(this.cutsToMinsize(toShrink), this.cutsToMinsizePlus1(toShrink), this.cutInHalves(toShrink)).filter(l -> l.size() >= this.minSize);
    }

    public Stream<List<T>> cutsToMinsize(List<? extends T> toShrink) {
        LinkedHashSet<List<T>> lists = new LinkedHashSet<List<T>>();
        this.appendLeftCut(toShrink, lists, this.minSize);
        this.appendRightCut(toShrink, lists, this.minSize);
        return lists.stream();
    }

    public Stream<List<T>> cutsToMinsizePlus1(List<? extends T> toShrink) {
        if (toShrink.size() <= this.minSize + 1) {
            return Stream.empty();
        }
        LinkedHashSet<List<T>> lists = new LinkedHashSet<List<T>>();
        this.appendLeftCut(toShrink, lists, this.minSize + 1);
        this.appendRightCut(toShrink, lists, this.minSize + 1);
        return lists.stream();
    }

    public Stream<List<T>> cutInHalves(List<? extends T> toShrink) {
        int halfSize = toShrink.size() / 2;
        if (halfSize < this.minSize) {
            return Stream.empty();
        }
        LinkedHashSet<List<T>> lists = new LinkedHashSet<List<T>>();
        this.appendLeftCut(toShrink, lists, halfSize);
        this.appendRightCut(toShrink, lists, toShrink.size() - halfSize);
        return lists.stream();
    }

    private void appendLeftCut(List<? extends T> toShrink, Set<List<T>> lists, int elementsToKeep) {
        ArrayList<T> cut = new ArrayList<T>(toShrink);
        lists.add(cut.subList(0, elementsToKeep));
    }

    private void appendRightCut(List<? extends T> toShrink, Set<List<T>> lists, int elementsToKeep) {
        ArrayList<T> cut = new ArrayList<T>(toShrink);
        int elementsToCut = toShrink.size() - elementsToKeep;
        lists.add(cut.subList(elementsToCut, toShrink.size()));
    }
}

