/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;

public class MappedShrinkable<T, U>
implements Shrinkable<U> {
    private final Shrinkable<T> toMap;
    private final Function<? super T, ? extends U> mapper;

    public MappedShrinkable(Shrinkable<T> toMap, Function<? super T, ? extends U> mapper) {
        this.toMap = toMap;
        this.mapper = mapper;
    }

    public U value() {
        return this.mapper.apply(this.toMap.value());
    }

    public Stream<Shrinkable<U>> shrink() {
        return this.toMap.shrink().map(this::toMappedShrinkable);
    }

    public Shrinkable<U> toMappedShrinkable(Shrinkable<T> shrinkable) {
        return shrinkable.map(this.mapper);
    }

    public Optional<Shrinkable<U>> grow(Shrinkable<?> before, Shrinkable<?> after) {
        if (before instanceof MappedShrinkable && after instanceof MappedShrinkable) {
            Shrinkable<T> beforeToMap = ((MappedShrinkable)before).toMap;
            Shrinkable<T> afterToMap = ((MappedShrinkable)after).toMap;
            return this.toMap.grow(beforeToMap, afterToMap).map(this::toMappedShrinkable);
        }
        return this.toMap.grow(before, after).map(this::toMappedShrinkable);
    }

    public Stream<Shrinkable<U>> grow() {
        return this.toMap.grow().map(this::toMappedShrinkable);
    }

    public ShrinkingDistance distance() {
        return this.toMap.distance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedShrinkable that = (MappedShrinkable)o;
        return this.toMap.equals(that.toMap);
    }

    public int hashCode() {
        return this.toMap.hashCode();
    }

    public String toString() {
        return String.format("Mapped<%s>(%s)|%s", this.value().getClass().getSimpleName(), this.value(), this.toMap);
    }
}

