/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.state;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.state.Chain;
import net.jqwik.api.state.ChainArbitrary;
import net.jqwik.api.state.ChangeDetector;
import net.jqwik.api.state.Transformation;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.state.ShrinkableChain;
import net.jqwik.engine.support.ChooseRandomlyByFrequency;

public class DefaultChainArbitrary<T>
extends TypedCloneable
implements ChainArbitrary<T> {
    private int maxTransformations = Integer.MIN_VALUE;
    private Supplier<? extends ChangeDetector<? super T>> changeDetectorSupplier = ChangeDetector::alwaysTrue;
    private List<Tuple.Tuple2<Integer, Transformation<T>>> weightedTransformations = new ArrayList<Tuple.Tuple2<Integer, Transformation<T>>>();
    private final Supplier<? extends T> initialSupplier;

    public DefaultChainArbitrary(Supplier<? extends T> initialSupplier) {
        this.initialSupplier = initialSupplier;
    }

    public RandomGenerator<Chain<T>> generator(int genSize) {
        int effectiveMaxTransformations = this.maxTransformations != Integer.MIN_VALUE ? this.maxTransformations : (int)Math.max(Math.round(Math.sqrt(genSize)), 10L);
        ChooseRandomlyByFrequency<Transformation<T>> transformationGenerator = new ChooseRandomlyByFrequency<Transformation<T>>(this.weightedTransformations);
        return random -> new ShrinkableChain<T>(random.nextLong(), this.initialSupplier, transformationGenerator, this.changeDetectorSupplier, effectiveMaxTransformations, genSize);
    }

    public ChainArbitrary<T> withTransformation(int weight, Transformation<T> transformation) {
        if (weight <= 0) {
            throw new IllegalArgumentException("Weight must be at least 1");
        }
        DefaultChainArbitrary clone = (DefaultChainArbitrary)this.typedClone();
        ArrayList<Tuple.Tuple2<Integer, Transformation<T>>> newWeightedTransformations = new ArrayList<Tuple.Tuple2<Integer, Transformation<T>>>(this.weightedTransformations);
        newWeightedTransformations.add(Tuple.of((Object)weight, transformation));
        clone.weightedTransformations = newWeightedTransformations;
        return clone;
    }

    public ChainArbitrary<T> withMaxTransformations(int maxTransformations) {
        DefaultChainArbitrary clone = (DefaultChainArbitrary)this.typedClone();
        clone.maxTransformations = maxTransformations;
        return clone;
    }

    public ChainArbitrary<T> improveShrinkingWith(Supplier<? extends ChangeDetector<? super T>> changeDetectorSupplier) {
        DefaultChainArbitrary clone = (DefaultChainArbitrary)this.typedClone();
        clone.changeDetectorSupplier = changeDetectorSupplier;
        return clone;
    }

    public EdgeCases<Chain<T>> edgeCases(int maxEdgeCases) {
        return EdgeCases.none();
    }

    public boolean isGeneratorMemoizable() {
        return false;
    }
}

