/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class JqwikKotlinSupport {
    public static String javaOrKotlinName(Method targetMethod) {
        String name = targetMethod.getName();
        if (JqwikKotlinSupport.isKotlinClass(targetMethod.getDeclaringClass())) {
            if (JqwikKotlinSupport.isKotlinInternal(targetMethod)) {
                name = JqwikKotlinSupport.nameWithoutInternalPart(name);
            }
            if (JqwikKotlinSupport.hasMangledName(targetMethod)) {
                name = JqwikKotlinSupport.nameWithoutInlinedParameterHashes(name);
            }
        }
        return name;
    }

    private static boolean isKotlinInternal(Method method) {
        if ((method.getModifiers() & 1) == 0) {
            return false;
        }
        int lastDollarIndex = method.getName().lastIndexOf(36);
        return lastDollarIndex > 0 && lastDollarIndex < method.getName().length() - 1;
    }

    private static boolean hasMangledName(Method method) {
        String name = JqwikKotlinSupport.isKotlinInternal(method) ? JqwikKotlinSupport.nameWithoutInternalPart(method.getName()) : method.getName();
        return JqwikKotlinSupport.hasInlinedParameters(name);
    }

    private static boolean hasInlinedParameters(String name) {
        int lastIndexOfHyphen = name.lastIndexOf(45);
        return lastIndexOfHyphen >= 0 && lastIndexOfHyphen == name.length() - 8;
    }

    private static boolean isKotlinClass(Class<?> aClass) {
        for (Annotation annotation : aClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getTypeName().equals("kotlin.Metadata")) continue;
            return true;
        }
        return false;
    }

    private static String nameWithoutInternalPart(String name) {
        int lastDollarPosition = name.lastIndexOf(36);
        return name.substring(0, lastDollarPosition);
    }

    private static String nameWithoutInlinedParameterHashes(String name) {
        int lastDollarPosition = name.lastIndexOf(45);
        return name.substring(0, lastDollarPosition);
    }
}

