/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3;

import java.io.IOException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.CallingFormat;
import net.noderunner.amazon.s3.CanonicalString;
import net.noderunner.amazon.s3.Headers;
import net.noderunner.amazon.s3.Method;
import net.noderunner.amazon.s3.S3Object;
import net.noderunner.amazon.s3.UrlEncoder;
import org.apache.commons.httpclient.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryGenerator {
    private String awsAccessKeyId;
    private Key awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;
    private Long expiresIn = null;
    private Long expires = null;
    private static final Long DEFAULT_EXPIRES_IN = new Long(60000L);

    public QueryGenerator(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public QueryGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
    }

    public QueryGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public QueryGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.SUBDOMAIN);
    }

    public QueryGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, CallingFormat callingFormat) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80, callingFormat);
    }

    public QueryGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat callingFormat) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = CanonicalString.key(awsSecretAccessKey);
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.callingFormat = callingFormat;
        this.expiresIn = DEFAULT_EXPIRES_IN;
        this.expires = null;
    }

    public void setCallingFormat(CallingFormat format) {
        this.callingFormat = format;
    }

    public void setExpires(long millisSinceEpoch) {
        this.expires = new Long(millisSinceEpoch);
        this.expiresIn = null;
    }

    public void setExpiresIn(long millis) {
        this.expiresIn = new Long(millis);
        this.expires = null;
    }

    public URI create(Bucket bucket, Headers headers) {
        if (!bucket.validateName(this.callingFormat)) {
            throw new IllegalArgumentException("Invalid Bucket Name: " + bucket);
        }
        return this.generateURI(Method.PUT, bucket, "", headers);
    }

    public URI list(Bucket bucket, String prefix, String marker, Integer maxKeys, Headers headers) {
        return this.list(bucket, prefix, marker, maxKeys, null, headers);
    }

    public URI list(Bucket bucket, String prefix, String marker, Integer maxKeys, String delimiter, Headers headers) {
        return this.generateURI(Method.GET, bucket, headers);
    }

    public URI delete(Bucket bucket, Headers headers) {
        return this.generateURI(Method.DELETE, bucket, headers);
    }

    public URI put(Bucket bucket, String key, S3Object object, Headers headers) {
        Headers metadata = null;
        if (object != null) {
            metadata = object.getMetadata();
        }
        if (headers == null) {
            headers = new Headers();
        }
        return this.generateURI(Method.PUT, bucket, key, headers.mergeMetadata(metadata));
    }

    public URI get(Bucket bucket, String key, Headers headers) {
        return this.generateURI(Method.GET, bucket, key, headers);
    }

    public URI delete(Bucket bucket, String key, Headers headers) {
        return this.generateURI(Method.DELETE, bucket, key, headers);
    }

    private Map<String, String> map(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(name, "");
        return map;
    }

    public URI getBucketLogging(Bucket bucket, Headers headers) {
        return this.generateURI(Method.GET, bucket, "", this.map("logging"), headers);
    }

    public URI putBucketLogging(Bucket bucket, Headers headers) {
        return this.generateURI(Method.PUT, bucket, "", this.map("logging"), headers);
    }

    public URI getACL(Bucket bucket, Headers headers) {
        return this.getACL(bucket, "", headers);
    }

    public URI getACL(Bucket bucket, String key, Headers headers) {
        return this.generateURI(Method.GET, bucket, key, this.map("acl"), headers);
    }

    public URI putACL(Bucket bucket, Headers headers) {
        return this.putACL(bucket, "", headers);
    }

    public URI putACL(Bucket bucket, String key, Headers headers) {
        return this.generateURI(Method.PUT, bucket, key, this.map("acl"), headers);
    }

    public URI listAllBuckets(Headers headers) {
        return this.generateURI(Method.GET, headers);
    }

    public URI listAllBuckets() {
        return this.listAllBuckets(null);
    }

    public String makeBareURI(Bucket bucket, String key) {
        StringBuilder buffer = new StringBuilder();
        if (this.isSecure) {
            buffer.append("https://");
        } else {
            buffer.append("http://");
        }
        buffer.append(this.server).append(":").append(this.port).append("/").append(bucket);
        buffer.append("/").append(UrlEncoder.encode(key));
        return buffer.toString();
    }

    private URI generateURI(Method method, Bucket bucket, String key, Headers headers) {
        return this.generateURI(method, bucket, key, new HashMap<String, String>(), headers);
    }

    private URI generateURI(Method method, Bucket bucket, Headers headers) {
        return this.generateURI(method, bucket, "", headers);
    }

    private URI generateURI(Method method, Headers headers) {
        return this.generateURI(method, null, headers);
    }

    private URI generateURI(Method method, Bucket bucket, String key, Map<String, String> pathArgs, Headers headers) {
        long expires = 0L;
        if (this.expiresIn != null) {
            expires = System.currentTimeMillis() + this.expiresIn;
        } else if (this.expires != null) {
            expires = this.expires;
        } else {
            throw new RuntimeException("Illegal expires state");
        }
        String enckey = UrlEncoder.encode(key);
        String canonicalString = CanonicalString.make(method, bucket, enckey, pathArgs, headers, "" + (expires /= 1000L));
        String encodedCanonical = CanonicalString.encode(this.awsSecretAccessKey, canonicalString);
        pathArgs.put("Signature", encodedCanonical);
        pathArgs.put("Expires", Long.toString(expires));
        pathArgs.put("AWSAccessKeyId", this.awsAccessKeyId);
        try {
            return this.callingFormat.getURI(this.isSecure, this.server, this.port, bucket, key, pathArgs);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to generate URI " + e);
        }
    }
}

