/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.amazon.s3.emulator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.noderunner.amazon.s3.Entry;
import net.noderunner.amazon.s3.Headers;
import net.noderunner.amazon.s3.Owner;
import net.noderunner.amazon.s3.S3Object;
import net.noderunner.amazon.s3.emulator.Writer;
import net.noderunner.http.servlet.ServletServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Server
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private transient ServletServer ss;
    private boolean bucket = false;
    private SortedMap<Entry, S3Object> map = Collections.synchronizedSortedMap(new TreeMap());

    public Server() throws IOException {
        this.ss = new ServletServer((HttpServlet)this);
        this.log.info((Object)("Server created " + (Object)((Object)this)));
    }

    public void close() throws IOException {
        this.log("close");
        this.ss.close();
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Entry e = this.entry(req);
        S3Object remove = (S3Object)this.map.remove(e);
        if (remove == null) {
            resp.sendError(404, "Not found " + e);
        } else {
            resp.sendError(204, "Deleted");
        }
    }

    private Entry entry(HttpServletRequest req) {
        return new Entry(this.key(this.uri(req)));
    }

    public int getPort() {
        return this.ss.getPort();
    }

    public void start() {
        this.ss.start();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI uri = this.uri(req);
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log("doGet " + uri);
        }
        if ("/".equals(uri.getPath())) {
            this.list(req, resp);
        } else {
            String key = uri.getPath().substring(1);
            Entry e = new Entry(key);
            S3Object obj = (S3Object)this.map.get(e);
            if (debug) {
                this.log("map.get(" + key + ") = " + obj);
            }
            if (obj == null) {
                resp.sendError(404, "Not here: " + e);
                return;
            }
            Headers h = new Headers();
            h = h.mergeMetadata(obj.getMetadata());
            for (Map.Entry<String, List<String>> me : h.getHeaders().entrySet()) {
                for (String v : me.getValue()) {
                    resp.setHeader(me.getKey(), v);
                }
            }
            resp.getOutputStream().write(obj.getData());
        }
    }

    private void list(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String prefix = req.getParameter("prefix");
        String marker = req.getParameter("marker");
        String delimiter = req.getParameter("delimiter");
        String maxKeysStr = req.getParameter("max-keys");
        if (this.log.isDebugEnabled()) {
            this.log("list prefix=" + prefix + " delimiter=" + delimiter);
        }
        int maxKeys = Integer.MAX_VALUE;
        if (maxKeysStr != null) {
            maxKeys = Integer.parseInt(maxKeysStr);
        }
        Writer w = new Writer();
        SortedMap<Entry, S3Object> submap = new TreeMap<Entry, S3Object>(this.map);
        if (prefix != null) {
            submap = submap.tailMap(new Entry(prefix));
        }
        int keyCount = 0;
        boolean truncated = false;
        String nextMarker = null;
        for (Entry e : submap.keySet()) {
            String key;
            if (++keyCount > maxKeys) {
                truncated = true;
                break;
            }
            String remain = key = e.getKey();
            nextMarker = key;
            if (prefix != null) {
                if (!key.startsWith(prefix)) break;
                remain = key.substring(prefix.length());
            }
            if (delimiter != null && remain.indexOf(delimiter) != -1) continue;
            if (this.log.isDebugEnabled()) {
                this.log("include key=" + key);
            }
            w.start("Contents");
            w.start("Key").write(key).end();
            w.start("LastModified").write(e.getLastModified()).end();
            w.start("Size").write(e.getSize()).end();
            w.start("Owner");
            w.start("ID").write(e.getOwner().getId()).end().start("DisplayName").write(e.getOwner().getDisplayName()).end();
            w.end();
            w.end();
        }
        Writer hw = new Writer();
        hw.start("ListBucketResult");
        hw.start("Name").write("localhost").end();
        hw.start("Prefix").write(this.s(prefix)).end();
        hw.start("Marker").write(this.s(marker)).end();
        if (delimiter != null) {
            hw.start("Delimiter").write(delimiter).end();
            if (truncated) {
                hw.start("NextMarker").write(nextMarker).end();
            }
        }
        hw.start("IsTruncated").write(String.valueOf(truncated)).end();
        if (maxKeysStr != null) {
            hw.start("MaxKeys").write(maxKeysStr).end();
        }
        hw.write(w);
        hw.end();
        PrintWriter pw = resp.getWriter();
        pw.write(hw.toString());
        pw.flush();
        this.bucket = true;
    }

    private String s(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI uri = this.uri(req);
        if (this.log.isDebugEnabled()) {
            this.log("doHead " + uri);
        }
        if (this.map.containsKey(this.entry(req))) {
            this.log("found");
            resp.sendError(200, "Found URI");
        } else {
            this.log("not found");
            resp.sendError(404, "Not found");
        }
    }

    private URI uri(HttpServletRequest req) {
        try {
            return new URI(req.getRequestURI());
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException(e1);
        }
    }

    private String key(URI uri) {
        return uri.getPath().substring(1);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI uri = this.uri(req);
        this.log("doPut " + uri);
        if ("/".equals(uri.getPath())) {
            this.log("create bucket");
            this.bucket = true;
        } else {
            int len;
            Entry e = new Entry(this.key(uri));
            e.setLastModified(new Date());
            e.setSize(req.getContentLength());
            e.setOwner(new Owner("id", "name"));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ServletInputStream is = req.getInputStream();
            byte[] b = new byte[128];
            while ((len = is.read(b)) != -1) {
                os.write(b, 0, len);
            }
            S3Object s3 = new S3Object(os.toByteArray());
            this.map.put(e, s3);
            Headers h = new Headers();
            Enumeration names = req.getHeaderNames();
            for (String n : Collections.list(names)) {
                h.put(n, req.getHeader(n));
            }
            s3.setMetadata(h.extractMetadata());
            this.log("put '" + e + "' as: " + s3);
        }
    }

    public void log(String s) {
        this.log.debug((Object)s);
    }

    public String toString() {
        return super.toString() + " bucket=" + this.bucket + " ss=" + this.ss + " map=" + this.map + "";
    }
}

