/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import net.noderunner.http.HttpServer;
import net.noderunner.http.IllegalHttpStateException;
import net.noderunner.http.ServerRequest;
import net.noderunner.http.ServerResponse;

public class BasicHttpServer
implements HttpServer {
    private final OutputStream os;
    private final Writer writer;
    private final InputStream is;
    private Socket socket;
    private State state;

    public BasicHttpServer(Socket socket) throws IOException {
        this(socket.getOutputStream(), new BufferedInputStream(socket.getInputStream()));
        this.socket = socket;
    }

    public BasicHttpServer(OutputStream os, InputStream is) {
        if (os == null) {
            throw new IllegalArgumentException("Null OutputStream");
        }
        if (is == null) {
            throw new IllegalArgumentException("Null InputStream");
        }
        this.os = os;
        this.writer = new BufferedWriter(new OutputStreamWriter(os));
        this.is = is;
        this.state = State.INITIAL;
    }

    public ServerRequest readRequest() throws IOException {
        if (this.state != State.INITIAL && this.state != State.WROTE_RESPONSE) {
            throw new IllegalHttpStateException("Invalid HTTP state");
        }
        this.state = State.READ_REQUEST;
        return new ServerRequest(this.is);
    }

    public void writeResponse(ServerResponse response) throws IOException {
        if (this.state != State.READ_REQUEST && this.state != State.WROTE_CONTINUE) {
            throw new IllegalHttpStateException("Invalid HTTP state");
        }
        if (response == null) {
            throw new IllegalArgumentException("Null ServerResponse");
        }
        this.state = response.isContinue() ? State.WROTE_CONTINUE : State.WROTE_RESPONSE;
        this.writer.write(response.getStatusLine().toString());
        this.writer.write("\r\n");
        response.getHeaders().write(this.writer);
        this.writer.write("\r\n");
        this.writer.flush();
        if (response.getDataPoster() != null) {
            response.getDataPoster().sendData(this.getOutputStream());
        }
    }

    public OutputStream getOutputStream() {
        if (this.state != State.WROTE_RESPONSE) {
            throw new IllegalHttpStateException("Invalid HTTP state " + (Object)((Object)this.state));
        }
        this.state = State.INITIAL;
        return this.os;
    }

    public void close() throws IOException {
        this.state = State.CLOSED;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
    }

    public String toString() {
        return "BasicHttpServer state=" + (Object)((Object)this.state) + " socket=" + this.socket;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INITIAL,
        READ_REQUEST,
        WROTE_RESPONSE,
        WROTE_CONTINUE,
        CLOSED;

    }
}

