/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private final InputStream stream;
    private int remaining;

    public LimitedInputStream(InputStream stream, int lengthLimit) {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream parameter is null");
        }
        this.stream = stream;
        this.remaining = lengthLimit;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int got;
        if (this.remaining == 0) {
            return -1;
        }
        if (len > this.remaining) {
            len = this.remaining;
        }
        if ((got = this.stream.read(b, off, len)) != -1) {
            this.remaining -= got;
        }
        return got;
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public void reset() throws IOException {
        this.stream.reset();
    }

    public void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    public int read() throws IOException {
        if (this.remaining == 0) {
            return -1;
        }
        int r = this.stream.read();
        if (r != -1) {
            --this.remaining;
        }
        return r;
    }

    public String toString() {
        return "LimitedInputStream  stream=" + this.stream + " remaining=" + this.remaining;
    }
}

