/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.noderunner.http.ByteArrayDataPoster;
import net.noderunner.http.ContentType;
import net.noderunner.http.MessageHeaders;
import net.noderunner.http.ServerResponse;
import net.noderunner.http.StatusLine;
import net.noderunner.http.servlet.HttpDateFormat;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private MessageHeaders headers;
    private ByteArrayOutputStream baos;
    private int statusCode;
    private String statusReason;
    private String encoding = "ISO-8859-1";
    private Locale locale = Locale.getDefault();
    private PrintWriter pw;
    private ServletOutputStream sos;

    public HttpServletResponseImpl() {
        this.reset();
    }

    public void addCookie(Cookie c) {
        throw new UnsupportedOperationException();
    }

    public void addDateHeader(String name, long d) {
        String string = new HttpDateFormat().format(new Date(d));
        this.headers.add(name, string);
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.add(name, String.valueOf(value));
    }

    public boolean containsHeader(String name) {
        return this.headers.getNames().contains(name);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public void sendError(int error) throws IOException {
        this.statusCode = error;
    }

    public void sendError(int error, String reason) throws IOException {
        this.statusCode = error;
        this.statusReason = reason;
    }

    public void sendRedirect(String arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setDateHeader(String name, long value) {
        this.headers.remove(name);
        this.addDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.headers.remove(name);
        this.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.remove(name);
        this.addIntHeader(name, value);
    }

    public void setStatus(int error) {
        this.statusCode = error;
    }

    public void setStatus(int error, String reason) {
        this.statusCode = error;
        this.statusReason = reason;
    }

    public void flushBuffer() throws IOException {
        if (this.pw != null) {
            this.pw.flush();
        }
    }

    public int getBufferSize() {
        return this.baos.size();
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    private String getHeader(String header) {
        return this.headers.getFieldContent(header);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.sos != null) {
            return this.sos;
        }
        this.sos = new ServletOutputStream(){

            public void write(int c) throws IOException {
                HttpServletResponseImpl.this.baos.write(c);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                HttpServletResponseImpl.this.baos.write(b, off, len);
            }
        };
        return this.sos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.pw != null) {
            return this.pw;
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.baos, this.encoding);
        this.pw = new PrintWriter(w);
        return this.pw;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.baos = new ByteArrayOutputStream();
        this.headers = new MessageHeaders();
        this.statusCode = StatusLine.HTTP11_200_OK.getStatusCode();
        this.statusReason = StatusLine.HTTP11_200_OK.getReasonPhrase();
    }

    public void resetBuffer() {
        this.baos.reset();
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException();
        }
        this.encoding = encoding;
    }

    public void setContentLength(int len) {
        this.setIntHeader("content-length", len);
    }

    public void setContentType(String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        String enc = ContentType.parse(type).getParameterValue("encoding");
        if (enc != null) {
            this.setCharacterEncoding(enc);
        }
        this.setHeader("content-type", type);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    ServerResponse createServerResponse() throws IOException {
        this.flushBuffer();
        if (this.pw != null) {
            this.pw.close();
        }
        this.setContentLength(this.baos.size());
        StatusLine sl = new StatusLine(this.statusCode, this.statusReason);
        ByteArrayDataPoster dp = new ByteArrayDataPoster(this.baos.toByteArray());
        ServerResponse sr = new ServerResponse(sl, this.headers, dp);
        return sr;
    }
}

