/*
 * Decompiled with CFR 0.152.
 */
package net.nullschool.util;

import java.security.SecureRandom;
import java.util.UUID;
import net.nullschool.util.DigitalRandomSpi;
import net.nullschool.util.RdRandEngine;

public final class DigitalRandom
extends SecureRandom {
    private static final int KEEP_24_BITS = 0xFFFFFF;
    private static final int KEEP_31_BITS = Integer.MAX_VALUE;
    private static final long KEEP_53_BITS = 0x1FFFFFFFFFFFFFL;
    private static final long KEEP_63_BITS = Long.MAX_VALUE;
    private final DigitalRandomSpi spi;
    private static final long serialVersionUID = 1L;

    private DigitalRandom(DigitalRandomSpi spi) {
        super(spi, null);
        this.spi = spi;
    }

    public DigitalRandom() throws UnsupportedOperationException {
        this(new RdRandEngine());
    }

    @Override
    public String getAlgorithm() {
        return "DRNG";
    }

    @Override
    public boolean nextBoolean() {
        return this.spi.engineNextInt() < 0;
    }

    @Override
    public int nextInt() {
        return this.spi.engineNextInt();
    }

    @Override
    public int nextInt(int bound) {
        int result;
        int sample;
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive.");
        }
        while ((sample = this.spi.engineNextInt() & Integer.MAX_VALUE) - (result = sample % bound) + bound - 1 <= 0) {
        }
        return result;
    }

    @Override
    public int nextInt(int least, int bound) {
        if (least >= bound) {
            throw new IllegalArgumentException("bound must be greater than least.");
        }
        return this.nextInt(bound - least) + least;
    }

    @Override
    public long nextLong() {
        return this.spi.engineNextLong();
    }

    @Override
    public long nextLong(long bound) {
        long result;
        long sample;
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive.");
        }
        while ((sample = this.spi.engineNextLong() & Long.MAX_VALUE) - (result = sample % bound) + bound - 1L <= 0L) {
        }
        return result;
    }

    @Override
    public long nextLong(long least, long bound) {
        if (least >= bound) {
            throw new IllegalArgumentException("bound must be greater than least.");
        }
        return this.nextLong(bound - least) + least;
    }

    @Override
    public float nextFloat() {
        return (float)(this.spi.engineNextInt() & 0xFFFFFF) / 1.6777216E7f;
    }

    @Override
    public double nextDouble() {
        return (double)(this.spi.engineNextLong() & 0x1FFFFFFFFFFFFFL) / 9.007199254740992E15;
    }

    @Override
    public double nextDouble(double least, double bound) {
        if (least >= bound) {
            throw new IllegalArgumentException("bound must be greater than least.");
        }
        return this.nextDouble() * (bound - least) + least;
    }

    public UUID nextUUID() {
        return new UUID(this.spi.engineNextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L, this.spi.engineNextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.spi.engineNextBytes(bytes);
    }
}

