/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import net.roboconf.dm.rest.client.delegates.ApplicationWsDelegate;
import net.roboconf.dm.rest.client.delegates.ManagementWsDelegate;
import net.roboconf.dm.rest.commons.json.ObjectMapperProvider;

public class WsClient {
    private final ApplicationWsDelegate applicationDelegate;
    private final ManagementWsDelegate managementDelegate;
    private final Client client;

    public WsClient(String rootUrl) {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(JacksonJsonProvider.class);
        cc.getClasses().add(ObjectMapperProvider.class);
        this.client = Client.create((ClientConfig)cc);
        this.client.setFollowRedirects(Boolean.valueOf(true));
        WebResource resource = this.client.resource(rootUrl);
        this.applicationDelegate = new ApplicationWsDelegate(resource);
        this.managementDelegate = new ManagementWsDelegate(resource);
    }

    public void destroy() {
        this.client.destroy();
    }

    public ApplicationWsDelegate getApplicationDelegate() {
        return this.applicationDelegate;
    }

    public ManagementWsDelegate getManagementDelegate() {
        return this.managementDelegate;
    }

    public Client getJerseyClient() {
        return this.client;
    }
}

