/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.client.delegates;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.dm.rest.client.exceptions.ApplicationException;

public class ApplicationWsDelegate {
    private final WebResource resource;
    private final Logger logger;

    public ApplicationWsDelegate(WebResource resource) {
        this.resource = resource;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void changeInstanceState(String applicationName, Instance.InstanceStatus newStatus, String instancePath) throws ApplicationException {
        ClientResponse response;
        this.logger.finer("Changing state of " + instancePath + " to '" + newStatus + "' in " + applicationName + ".");
        WebResource path = this.resource.path("app").path(applicationName).path("change-state");
        if (instancePath != null) {
            path = path.queryParam("instance-path", instancePath);
        }
        if (newStatus != null) {
            path = path.queryParam("new-state", newStatus.toString());
        }
        if (Response.Status.Family.SUCCESSFUL != (response = (ClientResponse)path.accept(new String[]{"application/json"}).post(ClientResponse.class)).getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ApplicationException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public void deployAndStartAll(String applicationName, String instancePath) throws ApplicationException {
        ClientResponse response;
        this.logger.finer("Deploying and starting instances in " + applicationName + " from instance = " + instancePath);
        WebResource path = this.resource.path("app").path(applicationName).path("deploy-all");
        if (instancePath != null) {
            path = path.queryParam("instance-path", instancePath);
        }
        if (Response.Status.Family.SUCCESSFUL != (response = (ClientResponse)path.accept(new String[]{"application/json"}).post(ClientResponse.class)).getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ApplicationException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public void stopAll(String applicationName, String instancePath) throws ApplicationException {
        ClientResponse response;
        this.logger.finer("Stopping instances in " + applicationName + " from instance = " + instancePath);
        WebResource path = this.resource.path("app").path(applicationName).path("stop-all");
        if (instancePath != null) {
            path = path.queryParam("instance-path", instancePath);
        }
        if (Response.Status.Family.SUCCESSFUL != (response = (ClientResponse)path.accept(new String[]{"application/json"}).post(ClientResponse.class)).getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ApplicationException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public void undeployAll(String applicationName, String instancePath) throws ApplicationException {
        ClientResponse response;
        this.logger.finer("Undeploying instances in " + applicationName + " from instance = " + instancePath);
        WebResource path = this.resource.path("app").path(applicationName).path("undeploy-all");
        if (instancePath != null) {
            path = path.queryParam("instance-path", instancePath);
        }
        if (Response.Status.Family.SUCCESSFUL != (response = (ClientResponse)path.accept(new String[]{"application/json"}).post(ClientResponse.class)).getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ApplicationException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public List<Instance> listChildrenInstances(String applicationName, String instancePath, boolean all) {
        List result;
        this.logger.finer("Listing children instances for " + instancePath + " in " + applicationName + ".");
        WebResource path = this.resource.path("app").path(applicationName).path("children").queryParam("all-children", String.valueOf(all));
        if (instancePath != null) {
            path = path.queryParam("instance-path", instancePath);
        }
        if ((result = (List)((WebResource.Builder)path.accept(new String[]{"application/json"}).type("application/json")).get((GenericType)new GenericType<List<Instance>>(){})) != null) {
            this.logger.finer(result.size() + " children instances were found for " + instancePath + " in " + applicationName + ".");
        } else {
            this.logger.finer("No child instance was found for " + instancePath + " in " + applicationName + ".");
        }
        return result != null ? result : new ArrayList();
    }

    public void addInstance(String applicationName, String parentInstancePath, Instance instance) throws ApplicationException {
        ClientResponse response;
        this.logger.finer("Adding an instance to the application " + applicationName + "...");
        WebResource path = this.resource.path("app").path(applicationName).path("instances");
        if (parentInstancePath != null) {
            path = path.queryParam("instance-path", parentInstancePath);
        }
        if (Response.Status.Family.SUCCESSFUL != (response = (ClientResponse)((WebResource.Builder)path.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)instance)).getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ApplicationException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public List<Component> listAllComponents(String applicationName) {
        this.logger.finer("Listing components for application " + applicationName + "...");
        List result = (List)this.resource.path("app").path(applicationName).path("components").accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Component>>(){});
        if (result != null) {
            this.logger.finer(result.size() + " components were found for the application " + applicationName + ".");
        } else {
            this.logger.finer("No component was found for the application " + applicationName + ".");
        }
        return result != null ? result : new ArrayList();
    }

    public List<Component> findPossibleComponentChildren(String applicationName, String instancePath) {
        List result;
        this.logger.finer("Listing possible child components for instance " + instancePath + "...");
        WebResource path = this.resource.path("app").path(applicationName).path("possibilities");
        if (instancePath != null) {
            path = path.queryParam("instance-path", instancePath);
        }
        if ((result = (List)path.accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Component>>(){})) != null) {
            this.logger.finer(result.size() + " possible children was or were found for " + instancePath + ".");
        } else {
            this.logger.finer("No possible child was found for " + instancePath + ".");
        }
        return result != null ? result : new ArrayList();
    }

    public List<String> findPossibleParentInstances(String applicationName, String componentName) {
        this.logger.finer("Listing possible parent instances for component " + componentName + "...");
        List result = (List)this.resource.path("app").path(applicationName).path("component").path(componentName).accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<String>>(){});
        if (result != null) {
            this.logger.finer(result.size() + " possible parents was or were found for " + componentName + ".");
        } else {
            this.logger.finer("No possible parent was found for " + componentName + ".");
        }
        return result != null ? result : new ArrayList();
    }
}

