/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.client.delegates;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.roboconf.core.model.beans.Application;
import net.roboconf.dm.rest.client.exceptions.ManagementException;

public class ManagementWsDelegate {
    private final WebResource resource;
    private final Logger logger;

    public ManagementWsDelegate(WebResource resource) {
        this.resource = resource;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public void loadApplication(File applicationFile) throws ManagementException, IOException {
        if (applicationFile == null || !applicationFile.exists() || !applicationFile.isFile()) {
            throw new IOException("Expected an existing file as parameter.");
        }
        this.logger.finer("Loading an application from " + applicationFile.getAbsolutePath() + "...");
        FormDataMultiPart part = new FormDataMultiPart();
        part.bodyPart((BodyPart)new FileDataBodyPart("file", applicationFile, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        ClientResponse response = (ClientResponse)this.resource.path("applications").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)part);
        if (Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ManagementException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public void loadApplication(String remoteFilePath) throws ManagementException {
        ClientResponse response;
        this.logger.finer("Loading an already-uploaded application. " + remoteFilePath);
        WebResource path = this.resource.path("applications").path("local");
        if (remoteFilePath != null) {
            path = path.queryParam("local-file-path", remoteFilePath);
        }
        if (Response.Status.Family.SUCCESSFUL != (response = (ClientResponse)path.type("application/json").post(ClientResponse.class)).getStatusInfo().getFamily()) {
            String value = (String)response.getEntity(String.class);
            this.logger.finer(response.getStatusInfo() + ": " + value);
            throw new ManagementException(response.getStatusInfo().getStatusCode(), value);
        }
        this.logger.finer(String.valueOf(response.getStatusInfo()));
    }

    public List<Application> listApplications() throws ManagementException {
        this.logger.finer("Listing applications...");
        List result = (List)this.resource.path("applications").accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Application>>(){});
        if (result != null) {
            this.logger.finer(result.size() + " applications were found on the DM.");
        } else {
            this.logger.finer("No application was found on the DM.");
        }
        return result != null ? result : new ArrayList();
    }

    public void shutdownApplication(String applicationName) throws ManagementException {
        this.logger.finer("Removing application " + applicationName + "...");
        ClientResponse response = (ClientResponse)this.resource.path("applications").path(applicationName).path("shutdown").post(ClientResponse.class);
        String text = (String)response.getEntity(String.class);
        this.logger.finer(text);
        if (Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
            throw new ManagementException(response.getStatusInfo().getStatusCode(), text);
        }
    }

    public void deleteApplication(String applicationName) throws ManagementException {
        this.logger.finer("Removing application " + applicationName + "...");
        ClientResponse response = (ClientResponse)this.resource.path("applications").path(applicationName).path("delete").delete(ClientResponse.class);
        String text = (String)response.getEntity(String.class);
        this.logger.finer(text);
        if (Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
            throw new ManagementException(response.getStatusInfo().getStatusCode(), text);
        }
    }
}

