/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import java.io.File;
import net.thucydides.core.reports.TestOutcomeAdaptorReporter;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.adaptors.AdaptorService;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="import", requiresProject=false)
public class SerenityAdaptorMojo
extends AbstractMojo {
    @Parameter(property="import.target", defaultValue="${user.dir}/target/site/serenity", required=true)
    public File outputDirectory;
    @Parameter(property="import.format", required=true)
    public String format;
    @Parameter(property="import.source")
    public File source;
    private final EnvironmentVariables environmentVariables;
    private final AdaptorService adaptorService;
    private final TestOutcomeAdaptorReporter reporter = new TestOutcomeAdaptorReporter();

    public SerenityAdaptorMojo(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.adaptorService = new AdaptorService(environmentVariables);
    }

    public SerenityAdaptorMojo() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Importing external test reports");
        this.getLog().info((CharSequence)("Source directory: " + String.valueOf(this.source)));
        this.getLog().info((CharSequence)("Output directory: " + String.valueOf(this.getOutputDirectory())));
        try {
            this.getLog().info((CharSequence)("Adaptor: " + String.valueOf(this.adaptorService.getAdaptor(this.format))));
            this.reporter.registerAdaptor(this.adaptorService.getAdaptor(this.format));
            this.reporter.setOutputDirectory(this.outputDirectory);
            this.reporter.generateReportsFrom(this.source);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

