/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate;

import net.sf.cglib.proxy.Enhancer;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnEnhancer {
    private static ThreadLocal<Boolean> perThreadCheckCGLib;
    private static volatile boolean defaultCheckCGLib;
    private static final String JAVASSIST_STARTWITH = "org.javassist.tmp.";
    private static final String JAVASSIST_INDEXOF = "_$$_javassist_";

    private UnEnhancer() {
    }

    private static boolean isJavassistEnhanced(Class<?> c) {
        String className = c.getName();
        return className.startsWith(JAVASSIST_STARTWITH) || className.indexOf(JAVASSIST_INDEXOF) != -1;
    }

    public static <T> Class<T> unenhanceClass(Class<?> c) {
        boolean enhanced = true;
        while (c != null && enhanced) {
            enhanced = UnEnhancer.isCheckCGLib() && Enhancer.isEnhanced(c) || UnEnhancer.isJavassistEnhanced(c);
            if (!enhanced) continue;
            c = c.getSuperclass();
        }
        Class<?> ret = c;
        return ret;
    }

    public static <T> Class<T> getActualClass(Object object) {
        Class<?> c = object.getClass();
        boolean enhanced = true;
        while (c != null && enhanced) {
            enhanced = UnEnhancer.isCheckCGLib() && Enhancer.isEnhanced(c) || UnEnhancer.isJavassistEnhanced(c);
            if (!enhanced) continue;
            if (object instanceof HibernateProxy) {
                HibernateProxy hibernateProxy = (HibernateProxy)object;
                LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
                try {
                    Object impl = lazyInitializer.getImplementation();
                    if (impl != null) {
                        Class<?> ret = impl.getClass();
                        return ret;
                    }
                }
                catch (HibernateException ex) {
                    Logger.getLogger(UnEnhancer.class).warn((Object)"Unable to retrieve the underlying persistent object", (Throwable)ex);
                }
                Class ret = lazyInitializer.getPersistentClass();
                return ret;
            }
            c = c.getSuperclass();
        }
        Class<?> ret = c;
        return ret;
    }

    public static <T> T unenhanceObject(T object) {
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            Object ret = lazyInitializer.getImplementation();
            return (T)ret;
        }
        return object;
    }

    public static boolean isDefaultCheckCGLib() {
        return defaultCheckCGLib;
    }

    public static boolean isCheckCGLib() {
        if (perThreadCheckCGLib == null) {
            return defaultCheckCGLib;
        }
        Boolean isCheckCGLib = perThreadCheckCGLib.get();
        return isCheckCGLib == null ? defaultCheckCGLib : isCheckCGLib;
    }

    public static void setDefaultCheckCGLib(boolean defaultCheckCGLib) {
        UnEnhancer.defaultCheckCGLib = defaultCheckCGLib;
    }

    public static void setCheckCGLibForThisThread(boolean isCheckCGLib) {
        perThreadCheckCGLib = LazyHolder.perThreadCheckCGLib;
        perThreadCheckCGLib.set(isCheckCGLib);
    }

    public static void clearThreadLocal() {
        if (perThreadCheckCGLib != null) {
            perThreadCheckCGLib.remove();
        }
    }

    static {
        defaultCheckCGLib = true;
    }

    private static class LazyHolder {
        private static final ThreadLocal<Boolean> perThreadCheckCGLib = new ThreadLocal();

        private LazyHolder() {
        }
    }
}

