/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.IOException;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.text.TextPosition;

public class TextMetrics {
    private float x;
    private float baseline;
    private float width;
    private float height;
    private float pointSize;
    private float descent;
    private float ascent;
    private float fontSize;
    private PDFont font;

    public TextMetrics(TextPosition tp) {
        this.x = tp.getX();
        this.baseline = tp.getY();
        this.font = tp.getFont();
        this.width = tp.getWidth();
        this.height = tp.getHeight();
        this.pointSize = tp.getFontSizeInPt();
        this.fontSize = tp.getYScale();
        this.ascent = this.getAscent();
        this.descent = this.getDescent();
    }

    public void append(TextPosition tp) {
        this.width += tp.getX() - (this.x + this.width) + tp.getWidth();
        this.height = Math.max(this.height, tp.getHeight());
        this.ascent = Math.max(this.ascent, TextMetrics.getAscent(tp.getFont(), tp.getYScale()));
        this.descent = Math.min(this.descent, TextMetrics.getDescent(tp.getFont(), tp.getYScale()));
    }

    public float getX() {
        return this.x;
    }

    public float getTop() {
        if (this.ascent != 0.0f) {
            return this.baseline - this.ascent;
        }
        return this.baseline - this.getBoundingBoxAscent();
    }

    public float getBottom() {
        if (this.descent != 0.0f) {
            return this.baseline - this.descent;
        }
        return this.baseline - this.getBoundingBoxDescent();
    }

    public float getBaseline() {
        return this.baseline;
    }

    public float getAscent() {
        return TextMetrics.getAscent(this.font, this.fontSize);
    }

    public float getDescent() {
        float descent = TextMetrics.getDescent(this.font, this.fontSize);
        return descent > 0.0f ? -descent : descent;
    }

    public float getBoundingBoxDescent() {
        return TextMetrics.getBoundingBoxDescent(this.font, this.fontSize);
    }

    public float getBoundingBoxAscent() {
        return TextMetrics.getBoundingBoxAscent(this.font, this.fontSize);
    }

    public static float getBoundingBoxDescent(PDFont font, float fontSize) {
        try {
            BoundingBox bBox = font.getBoundingBox();
            float boxDescent = bBox.getLowerLeftY();
            return boxDescent / 1000.0f * fontSize;
        }
        catch (IOException iOException) {
            return 0.0f;
        }
    }

    public static float getBoundingBoxAscent(PDFont font, float fontSize) {
        try {
            BoundingBox bBox = font.getBoundingBox();
            float boxAscent = bBox.getUpperRightY();
            return boxAscent / 1000.0f * fontSize;
        }
        catch (IOException iOException) {
            return 0.0f;
        }
    }

    private static float getAscent(PDFont font, float fontSize) {
        try {
            return font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    private static float getDescent(PDFont font, float fontSize) {
        try {
            return font.getFontDescriptor().getDescent() / 1000.0f * fontSize;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.getBottom() - this.getTop();
    }

    public float getPointSize() {
        return this.pointSize;
    }
}

