/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.fit.pdfdom.FontTable;
import org.fit.pdfdom.PDFBoxTree;
import org.fit.pdfdom.PDFDomTreeConfig;
import org.fit.pdfdom.PathDrawer;
import org.fit.pdfdom.PathSegment;
import org.fit.pdfdom.TextMetrics;
import org.fit.pdfdom.resource.IgnoreResourceHandler;
import org.fit.pdfdom.resource.ImageResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class PDFDomTree
extends PDFBoxTree {
    private static Logger log = LoggerFactory.getLogger(PDFDomTree.class);
    protected String defaultStyle = ".page{position:relative; border:1px solid blue;margin:0.5em}\n.p,.r{position:absolute;}\n@supports(-webkit-text-stroke: 1px black) {.p{text-shadow:none !important;}}";
    protected Document doc;
    protected Element head;
    protected Element body;
    protected Element title;
    protected Element globalStyle;
    protected Element curpage;
    protected int textcnt;
    protected int pagecnt;
    protected PDFDomTreeConfig config;

    public PDFDomTree() throws IOException {
        this.init();
    }

    public PDFDomTree(PDFDomTreeConfig config) throws IOException {
        this();
        if (config != null) {
            this.config = config;
        }
    }

    private void init() {
        this.pagecnt = 0;
        this.textcnt = 0;
        this.config = PDFDomTreeConfig.createDefaultConfig();
    }

    protected void createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        DocumentType doctype = builder.getDOMImplementation().createDocumentType("html", "-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        this.doc = builder.getDOMImplementation().createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        this.head = this.doc.createElement("head");
        Element meta = this.doc.createElement("meta");
        meta.setAttribute("http-equiv", "content-type");
        meta.setAttribute("content", "text/html;charset=utf-8");
        this.head.appendChild(meta);
        this.title = this.doc.createElement("title");
        this.title.setTextContent("PDF Document");
        this.head.appendChild(this.title);
        this.globalStyle = this.doc.createElement("style");
        this.globalStyle.setAttribute("type", "text/css");
        this.head.appendChild(this.globalStyle);
        this.body = this.doc.createElement("body");
        Element root = this.doc.getDocumentElement();
        root.appendChild(this.head);
        root.appendChild(this.body);
    }

    public Document getDocument() {
        return this.doc;
    }

    public void startDocument(PDDocument document) throws IOException {
        try {
            this.createDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error: parser configuration error", e);
        }
    }

    protected void endDocument(PDDocument document) throws IOException {
        String doctitle = document.getDocumentInformation().getTitle();
        if (doctitle != null && doctitle.trim().length() > 0) {
            this.title.setTextContent(doctitle);
        }
        this.globalStyle.setTextContent(this.createGlobalStyle());
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            writer.getDomConfig().setParameter("format-pretty-print", true);
            output.setCharacterStream(outputStream);
            this.createDOM(doc);
            writer.write(this.getDocument(), output);
        }
        catch (ClassCastException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Error: cannot initialize the DOM serializer", e);
        }
    }

    public Document createDOM(PDDocument doc) throws IOException {
        super.writeText(doc, (Writer)new OutputStreamWriter(System.out));
        return this.doc;
    }

    @Override
    protected void startNewPage() {
        this.curpage = this.createPageElement();
        this.body.appendChild(this.curpage);
    }

    @Override
    protected void renderText(String data, TextMetrics metrics) {
        this.curpage.appendChild(this.createTextElement(data, metrics.getWidth()));
    }

    @Override
    protected void renderPath(List<PathSegment> path, boolean stroke, boolean fill) throws IOException {
        float[] rect = this.toRectangle(path);
        if (rect != null) {
            this.curpage.appendChild(this.createRectangleElement(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1], stroke, fill));
        } else if (stroke) {
            for (PathSegment segm : path) {
                this.curpage.appendChild(this.createLineElement(segm.getX1(), segm.getY1(), segm.getX2(), segm.getY2()));
            }
        } else {
            Element pathImage = this.createPathImage(path);
            if (pathImage != null) {
                this.curpage.appendChild(pathImage);
            }
        }
    }

    @Override
    protected void renderImage(float x, float y, float width, float height, ImageResource resource) throws IOException {
        this.curpage.appendChild(this.createImageElement(x, y, width, height, resource));
    }

    protected Element createPageElement() {
        String pstyle = "";
        PDRectangle layout = this.getCurrentMediaBox();
        if (layout != null) {
            float w = layout.getWidth();
            float h = layout.getHeight();
            int rot = this.pdpage.getRotation();
            if (rot == 90 || rot == 270) {
                float x = w;
                w = h;
                h = x;
            }
            pstyle = "width:" + w + "pt" + ";height:" + h + "pt" + ";";
            pstyle = pstyle + "overflow:hidden;";
        } else {
            log.warn("No media box found");
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("id", "page_" + this.pagecnt++);
        el.setAttribute("class", "page");
        el.setAttribute("style", pstyle);
        return el;
    }

    protected Element createTextElement(float width) {
        Element el = this.doc.createElement("div");
        el.setAttribute("id", "p" + this.textcnt++);
        el.setAttribute("class", "p");
        String style = this.curstyle.toString();
        style = style + "width:" + width + "pt" + ";";
        el.setAttribute("style", style);
        return el;
    }

    protected Element createTextElement(String data, float width) {
        Element el = this.createTextElement(width);
        Text text = this.doc.createTextNode(data);
        el.appendChild(text);
        return el;
    }

    protected Element createRectangleElement(float x, float y, float width, float height, boolean stroke, boolean fill) {
        float lineWidth = this.transformWidth(this.getGraphicsState().getLineWidth());
        float wcor = stroke ? lineWidth : 0.0f;
        float strokeOffset = wcor == 0.0f ? 0.0f : wcor / 2.0f;
        width = width - wcor < 0.0f ? 1.0f : width - wcor;
        height = height - wcor < 0.0f ? 1.0f : height - wcor;
        StringBuilder pstyle = new StringBuilder(50);
        pstyle.append("left:").append(this.style.formatLength(x - strokeOffset)).append(';');
        pstyle.append("top:").append(this.style.formatLength(y - strokeOffset)).append(';');
        pstyle.append("width:").append(this.style.formatLength(width)).append(';');
        pstyle.append("height:").append(this.style.formatLength(height)).append(';');
        if (stroke) {
            String color = this.colorString(this.getGraphicsState().getStrokingColor());
            pstyle.append("border:").append(this.style.formatLength(lineWidth)).append(" solid ").append(color).append(';');
        }
        if (fill) {
            String fcolor = this.colorString(this.getGraphicsState().getNonStrokingColor());
            pstyle.append("background-color:").append(fcolor).append(';');
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("class", "r");
        el.setAttribute("style", pstyle.toString());
        el.appendChild(this.doc.createEntityReference("nbsp"));
        return el;
    }

    protected Element createLineElement(float x1, float y1, float x2, float y2) {
        HtmlDivLine line = new HtmlDivLine(x1, y1, x2, y2);
        String color = this.colorString(this.getGraphicsState().getStrokingColor());
        StringBuilder pstyle = new StringBuilder(50);
        pstyle.append("left:").append(this.style.formatLength(line.getLeft())).append(';');
        pstyle.append("top:").append(this.style.formatLength(line.getTop())).append(';');
        pstyle.append("width:").append(this.style.formatLength(line.getWidth())).append(';');
        pstyle.append("height:").append(this.style.formatLength(line.getHeight())).append(';');
        pstyle.append(line.getBorderSide()).append(':').append(this.style.formatLength(line.getLineStrokeWidth())).append(" solid ").append(color).append(';');
        if (line.getAngleDegrees() != 0.0) {
            pstyle.append("transform:").append("rotate(").append(line.getAngleDegrees()).append("deg);");
        }
        Element el = this.doc.createElement("div");
        el.setAttribute("class", "r");
        el.setAttribute("style", pstyle.toString());
        el.appendChild(this.doc.createEntityReference("nbsp"));
        return el;
    }

    protected Element createPathImage(List<PathSegment> path) throws IOException {
        PathDrawer drawer = new PathDrawer(this.getGraphicsState());
        ImageResource renderedPath = drawer.drawPath(path);
        if (renderedPath != null) {
            return this.createImageElement((float)renderedPath.getX(), (float)renderedPath.getY(), renderedPath.getWidth(), renderedPath.getHeight(), renderedPath);
        }
        return null;
    }

    protected Element createImageElement(float x, float y, float width, float height, ImageResource resource) throws IOException {
        StringBuilder pstyle = new StringBuilder("position:absolute;");
        pstyle.append("left:").append(x).append("pt").append(';');
        pstyle.append("top:").append(y).append("pt").append(';');
        pstyle.append("width:").append(width).append("pt").append(';');
        pstyle.append("height:").append(height).append("pt").append(';');
        Element el = this.doc.createElement("img");
        el.setAttribute("style", pstyle.toString());
        String imgSrc = this.config.getImageHandler().handleResource(resource);
        if (!this.disableImageData && !imgSrc.isEmpty()) {
            el.setAttribute("src", imgSrc);
        } else {
            el.setAttribute("src", "");
        }
        return el;
    }

    protected String createGlobalStyle() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.createFontFaces());
        ret.append("\n");
        ret.append(this.defaultStyle);
        return ret.toString();
    }

    @Override
    protected void updateFontTable() {
        if (!(this.config.getFontHandler() instanceof IgnoreResourceHandler)) {
            super.updateFontTable();
        }
    }

    protected String createFontFaces() {
        StringBuilder ret = new StringBuilder();
        for (FontTable.Entry font : this.fontTable.getEntries()) {
            this.createFontFace(ret, font);
        }
        return ret.toString();
    }

    private void createFontFace(StringBuilder ret, FontTable.Entry font) {
        ret.append("@font-face {");
        ret.append("font-family:\"").append(font.usedName).append("\";");
        ret.append("src:url('");
        try {
            String src = this.config.getFontHandler().handleResource(font);
            ret.append(src);
        }
        catch (IOException e) {
            log.error("Error writing font face data for font: " + font.getName() + "Exception: {} {}", (Object)e.getMessage(), e.getClass());
        }
        ret.append("');");
        ret.append("}\n");
    }

    protected class HtmlDivLine {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private final float width;
        private final float height;
        private final boolean horizontal;
        private final boolean vertical;

        public HtmlDivLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.width = Math.abs(x2 - x1);
            this.height = Math.abs(y2 - y1);
            this.horizontal = this.height < 0.5f;
            this.vertical = this.width < 0.5f;
        }

        public float getHeight() {
            return this.vertical ? this.height : 0.0f;
        }

        public float getWidth() {
            if (this.vertical) {
                return 0.0f;
            }
            if (this.horizontal) {
                return this.width;
            }
            return this.distanceFormula(this.x1, this.y1, this.x2, this.y2);
        }

        public float getLeft() {
            if (this.horizontal || this.vertical) {
                return Math.min(this.x1, this.x2);
            }
            return Math.abs((this.x2 + this.x1) / 2.0f) - this.getWidth() / 2.0f;
        }

        public float getTop() {
            if (this.horizontal || this.vertical) {
                return Math.min(this.y1, this.y2);
            }
            return Math.abs((this.y2 + this.y1) / 2.0f) - (this.getLineStrokeWidth() + this.getHeight()) / 2.0f;
        }

        public double getAngleDegrees() {
            if (this.horizontal || this.vertical) {
                return 0.0;
            }
            return Math.toDegrees(Math.atan((this.y2 - this.y1) / (this.x2 - this.x1)));
        }

        public float getLineStrokeWidth() {
            float lineWidth = PDFDomTree.this.transformWidth(PDFDomTree.this.getGraphicsState().getLineWidth());
            if (lineWidth < 0.5f) {
                lineWidth = 0.5f;
            }
            return lineWidth;
        }

        public String getBorderSide() {
            return this.vertical ? "border-right" : "border-bottom";
        }

        private float distanceFormula(float x1, float y1, float x2, float y2) {
            return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }
    }
}

