/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom.resource;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.fit.pdfdom.resource.HtmlResource;
import org.fit.pdfdom.resource.HtmlResourceHandler;

public class SaveResourceToDirHandler
implements HtmlResourceHandler {
    public static final String DEFAULT_RESOURCE_DIR = "resources/";
    private final File directory;
    private List<String> writtenFileNames = new LinkedList<String>();

    public SaveResourceToDirHandler() {
        this.directory = null;
    }

    public SaveResourceToDirHandler(File directory) {
        this.directory = directory;
    }

    @Override
    public String handleResource(HtmlResource resource) throws IOException {
        String dir = DEFAULT_RESOURCE_DIR;
        if (this.directory != null) {
            dir = this.directory.getPath() + "/";
        }
        String fileName = this.findNextUnusedFileName(resource.getName());
        String resourcePath = dir + fileName + "." + resource.getFileEnding();
        File file = new File(resourcePath);
        FileUtils.writeByteArrayToFile((File)file, (byte[])resource.getData());
        this.writtenFileNames.add(fileName);
        return resourcePath;
    }

    private String findNextUnusedFileName(String fileName) {
        int i = 1;
        String usedName = fileName;
        while (this.writtenFileNames.contains(usedName)) {
            usedName = fileName + i;
            ++i;
        }
        return usedName;
    }
}

