/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LatestFileResolver {
    private static final Pattern latestVersionPattern = Pattern.compile("(%latest%)");
    private static boolean _debug = Boolean.getBoolean("exist.start.debug");

    public String getResolvedFileName(String filename) {
        String patternString;
        Pattern pattern;
        Matcher matches = latestVersionPattern.matcher(filename);
        if (!matches.find()) {
            return filename;
        }
        String[] fileinfo = filename.split("%latest%");
        String uptoToken = fileinfo[0];
        String containerDirName = uptoToken.substring(0, uptoToken.lastIndexOf(File.separatorChar));
        File containerDir = new File(containerDirName);
        File[] jars = containerDir.listFiles(new FilenameFilter(pattern = Pattern.compile(patternString = uptoToken.substring(uptoToken.lastIndexOf(File.separatorChar) + 1) + "([\\d\\.\\-_]+)" + fileinfo[1])){
            private final /* synthetic */ Pattern val$pattern;
            {
                this.val$pattern = pattern;
            }

            public boolean accept(File dir, String name) {
                Matcher matches = this.val$pattern.matcher(name);
                return matches.find();
            }
        });
        if (jars == null) {
            System.err.println("ERROR: No jars found in " + containerDir.getAbsolutePath());
        } else {
            if (jars.length > 0) {
                String actualFileName = jars[0].getAbsolutePath();
                if (_debug) {
                    System.err.println("Found match: " + actualFileName + " for jar file pattern: " + filename);
                }
                return actualFileName;
            }
            if (_debug) {
                System.err.println("WARN: No latest version found for JAR file: '" + filename + "'");
            }
        }
        return filename;
    }
}

