/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.exist.start.Classpath;
import org.exist.start.LatestFileResolver;
import org.exist.start.Version;
import org.exist.storage.BrokerPool;

public class Main {
    private String _classname = null;
    private String _mode = "jetty";
    private static Main exist;
    private boolean _debug = Boolean.getBoolean("exist.start.debug");
    private String startConfigFileName = "";
    private final LatestFileResolver jarFileResolver = new LatestFileResolver();

    public static void main(String[] args) {
        try {
            Main.getMain().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Main getMain() {
        if (exist == null) {
            exist = new Main();
        }
        return exist;
    }

    public String getMode() {
        return this._mode;
    }

    private Main() {
    }

    public Main(String mode) {
        this._mode = mode;
    }

    static File getDirectory(String name) {
        try {
            File dir;
            if (name != null && (dir = new File(name).getCanonicalFile()).isDirectory()) {
                return dir;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    boolean isAvailable(String classname, Classpath classpath) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (ClassNotFoundException e) {
            ClassLoader loader = classpath.getClassLoader(null);
            try {
                loader.loadClass(classname);
                return true;
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
        }
    }

    public static void invokeMain(ClassLoader classloader, String classname, String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> invoked_class = null;
        invoked_class = classloader.loadClass(classname);
        Class[] method_param_types = new Class[]{args.getClass()};
        Method main = null;
        main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{args};
        main.invoke(null, method_params);
    }

    void configureClasspath(String home, Classpath classpath, InputStream config, String[] args, String mode) {
        ArrayList<String> invalidJars = new ArrayList<String>();
        try {
            BufferedReader cfg = new BufferedReader(new InputStreamReader(config, "ISO-8859-1"));
            Version java_version = new Version(System.getProperty("java.version"));
            Version ver = new Version();
            Hashtable<String, String> done = new Hashtable<String, String>();
            String line = cfg.readLine();
            while (line != null) {
                block30: {
                    try {
                        if (line.length() > 0 && !line.startsWith("#")) {
                            String file;
                            if (this._debug) {
                                System.err.println(">" + line);
                            }
                            StringTokenizer st = new StringTokenizer(line);
                            String subject = st.nextToken();
                            boolean include_subject = true;
                            String condition = null;
                            while (include_subject && st.hasMoreTokens()) {
                                String operator;
                                String class_to_check;
                                condition = st.nextToken();
                                if (condition.equals("never")) {
                                    include_subject = false;
                                    continue;
                                }
                                if (condition.equals("always")) continue;
                                if (condition.equals("available")) {
                                    class_to_check = st.nextToken();
                                    include_subject &= this.isAvailable(class_to_check, classpath);
                                    continue;
                                }
                                if (condition.equals("!available")) {
                                    class_to_check = st.nextToken();
                                    include_subject &= !this.isAvailable(class_to_check, classpath);
                                    continue;
                                }
                                if (condition.equals("java")) {
                                    operator = st.nextToken();
                                    String version = st.nextToken();
                                    ver.parse(version);
                                    include_subject &= operator.equals("<") && java_version.compare(ver) < 0 || operator.equals(">") && java_version.compare(ver) > 0 || operator.equals("<=") && java_version.compare(ver) <= 0 || operator.equals("=<") && java_version.compare(ver) <= 0 || operator.equals("=>") && java_version.compare(ver) >= 0 || operator.equals(">=") && java_version.compare(ver) >= 0 || operator.equals("==") && java_version.compare(ver) == 0 || operator.equals("!=") && java_version.compare(ver) != 0;
                                    continue;
                                }
                                if (condition.equals("nargs")) {
                                    operator = st.nextToken();
                                    int number = Integer.parseInt(st.nextToken());
                                    include_subject &= operator.equals("<") && args.length < number || operator.equals(">") && args.length > number || operator.equals("<=") && args.length <= number || operator.equals("=<") && args.length <= number || operator.equals("=>") && args.length >= number || operator.equals(">=") && args.length >= number || operator.equals("==") && args.length == number || operator.equals("!=") && args.length != number;
                                    continue;
                                }
                                if (condition.equals("mode")) {
                                    operator = st.nextToken();
                                    String m = st.nextToken();
                                    include_subject &= operator.equals("==") && mode.equals(m) || operator.equals("!=") && !mode.equals(m);
                                    continue;
                                }
                                System.err.println("ERROR: Unknown condition: " + condition);
                            }
                            String string = file = subject.startsWith("/") ? subject.replace('/', File.separatorChar) : home + File.separatorChar + subject.replace('/', File.separatorChar);
                            if (this._debug) {
                                System.err.println("subject=" + subject + " file=" + file + " condition=" + condition + " include_subject=" + include_subject);
                            }
                            if (subject.endsWith("/*")) {
                                File extdir = new File(file.substring(0, file.length() - 1));
                                File[] jars = extdir.listFiles(new FilenameFilter(){

                                    public boolean accept(File dir, String name) {
                                        String namelc = name.toLowerCase();
                                        return namelc.endsWith(".jar") || name.endsWith(".zip");
                                    }
                                });
                                if (jars != null) {
                                    for (int i = 0; i < jars.length; ++i) {
                                        String jar = jars[i].getCanonicalPath();
                                        if (done.containsKey(jar) || !include_subject) continue;
                                        done.put(jar, jar);
                                        if (!classpath.addComponent(jar) || !this._debug) continue;
                                        System.err.println("Adding JAR from directory: " + jar);
                                    }
                                }
                            } else if (subject.endsWith("/")) {
                                File cd = new File(file);
                                String d = cd.getCanonicalPath();
                                if (!done.containsKey(d)) {
                                    done.put(d, d);
                                    if (include_subject && classpath.addComponent(d) && this._debug) {
                                        System.err.println("Adding directory: " + d);
                                    }
                                }
                            } else if (subject.toLowerCase().endsWith(".class")) {
                                this._classname = subject.substring(0, subject.length() - 6);
                            } else {
                                String d;
                                String resolvedFile = this.jarFileResolver.getResolvedFileName(file);
                                File f = new File(resolvedFile);
                                if (include_subject && !f.exists()) {
                                    invalidJars.add(f.getAbsolutePath());
                                }
                                if (!done.containsKey(d = f.getCanonicalPath()) && include_subject) {
                                    done.put(d, d);
                                    if (classpath.addComponent(d) && this._debug) {
                                        System.err.println("Adding single JAR: " + d);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!this._debug) break block30;
                        System.err.println(line);
                        e.printStackTrace();
                    }
                }
                line = cfg.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (invalidJars.size() > 0) {
            Iterator it = invalidJars.iterator();
            StringBuffer nonexistentJars = new StringBuffer();
            while (it.hasNext()) {
                String invalidJar = (String)it.next();
                nonexistentJars.append("    " + invalidJar + "\n");
            }
            System.err.println("\nWARN: The following JAR file entries from '" + this.startConfigFileName + "' aren't available (this may NOT be a " + "problem):\n" + nonexistentJars);
        }
    }

    public void run(String[] args) {
        File _home_dir;
        if (args.length > 0) {
            if (args[0].equals("client")) {
                this._classname = "org.exist.client.InteractiveClient";
                this._mode = "client";
            } else if (args[0].equals("standalone")) {
                this._classname = "org.exist.StandaloneServer";
                this._mode = "standalone";
            } else if (args[0].equals("backup")) {
                this._classname = "org.exist.backup.Main";
                this._mode = "backup";
            } else if (args[0].equals("jetty")) {
                this._classname = "org.exist.JettyStart";
                this._mode = "jetty";
            } else if (args[0].equals("shutdown")) {
                this._classname = "org.exist.ServerShutdown";
                this._mode = "other";
            } else {
                this._classname = args[0];
                this._mode = "other";
            }
            String[] nargs = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, nargs, 0, args.length - 1);
            }
            args = nargs;
        } else {
            this._classname = "org.exist.client.InteractiveClient";
            this._mode = "client";
        }
        if (this._debug) {
            System.err.println("mode = " + this._mode);
        }
        if ((_home_dir = this.detectHome()) != null) {
            File lf;
            String log4j;
            if (this._debug) {
                System.err.println("EXIST_HOME=" + System.getProperty("exist.home"));
            }
            System.setProperty("exist.home", _home_dir.getPath());
            System.setProperty("user.dir", _home_dir.getPath());
            if (this._mode.equals("jetty") | this._mode.equals("cluster")) {
                File _tools_dir = new File(_home_dir.getAbsolutePath() + File.separatorChar + "tools");
                if (!_tools_dir.exists()) {
                    System.err.println("ERROR: tools directory not found in " + _home_dir.getAbsolutePath());
                    return;
                }
                String _jetty_dir = null;
                String[] _dirs = _tools_dir.list();
                for (int i = 0; i < _dirs.length; ++i) {
                    if (!_dirs[i].startsWith("jetty")) continue;
                    _jetty_dir = _dirs[i];
                    break;
                }
                if (_jetty_dir == null) {
                    System.err.println("ERROR: Jetty could not be found in " + _tools_dir.getPath());
                    return;
                }
                System.setProperty("jetty.home", _tools_dir.getAbsolutePath() + File.separatorChar + _jetty_dir);
                args = new String[]{System.getProperty("jetty.home") + File.separatorChar + "etc" + File.separatorChar + "jetty.xml"};
            }
            if ((log4j = System.getProperty("log4j.configuration")) == null && (lf = new File(log4j = _home_dir.getPath() + File.separatorChar + "log4j.xml")).canRead()) {
                System.setProperty("log4j.configuration", lf.toURI().toASCIIString());
            }
            try {
                File tmpdir = new File(System.getProperty("java.io.tmpdir")).getCanonicalFile();
                if (tmpdir.isDirectory()) {
                    System.setProperty("java.io.tmpdir", tmpdir.getPath());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            Classpath _classpath = this.constructClasspath(_home_dir, args);
            ClassLoader cl = _classpath.getClassLoader(null);
            Thread.currentThread().setContextClassLoader(cl);
            if (this._debug) {
                System.err.println("TEMPDIR=" + System.getProperty("java.io.tmpdir"));
            }
            try {
                Main.invokeMain(cl, this._classname, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("ERROR: exist.home cound not be autodetected, bailing out.");
            System.err.flush();
        }
    }

    public File detectHome() {
        File jar;
        File _home_dir = Main.getDirectory(System.getProperty("exist.home"));
        if (_home_dir == null) {
            File jar2;
            File webinf = new File("WEB-INF");
            if (this._debug) {
                System.err.println("trying " + webinf.getAbsolutePath());
            }
            if (webinf.exists() && (jar2 = new File(webinf.getPath() + File.separatorChar + "lib" + File.separatorChar + "exist.jar")).exists()) {
                try {
                    _home_dir = webinf.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = new File("exist.jar");
            if (this._debug) {
                System.err.println("trying " + jar.getAbsolutePath());
            }
            if (jar.canRead()) {
                try {
                    _home_dir = new File(".").getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = new File(".." + File.separatorChar + "exist.jar");
            if (this._debug) {
                System.err.println("trying " + jar.getAbsolutePath());
            }
            if (jar.exists()) {
                try {
                    _home_dir = new File("..").getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = new File("conf.xml");
            if (this._debug) {
                System.err.println("trying " + jar.getAbsolutePath());
            }
            if (jar.canRead()) {
                try {
                    _home_dir = new File(".").getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = new File(".." + File.separatorChar + "conf.xml");
            if (this._debug) {
                System.err.println("trying " + jar.getAbsolutePath());
            }
            if (jar.exists()) {
                try {
                    _home_dir = new File("..").getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return _home_dir;
    }

    public Classpath constructClasspath(File homeDir, String[] args) {
        Classpath _classpath = new Classpath();
        if (this._debug) {
            System.out.println("existing classpath = " + System.getProperty("java.class.path"));
        }
        _classpath.addClasspath(System.getProperty("java.class.path"));
        try {
            InputStream cpcfg = null;
            String configFilePath1 = "";
            String configFilePath2 = "";
            try {
                configFilePath1 = homeDir.getPath() + File.separatorChar + "start.config";
                cpcfg = new FileInputStream(configFilePath1);
                this.startConfigFileName = configFilePath1;
            }
            catch (FileNotFoundException e) {
                cpcfg = null;
            }
            if (cpcfg == null) {
                if (this._debug) {
                    System.err.println("Configuring classpath from default resource");
                }
                configFilePath2 = "org/exist/start/start.config";
                cpcfg = this.getClass().getClassLoader().getResourceAsStream(configFilePath2);
                this.startConfigFileName = configFilePath2;
            }
            if (cpcfg == null) {
                throw new RuntimeException("start.config not found at " + configFilePath1 + " or " + configFilePath2 + ", Bailing out.");
            }
            if (this._debug) {
                System.err.println("Configuring classpath from: " + this.startConfigFileName);
            }
            this.configureClasspath(homeDir.getPath(), _classpath, cpcfg, args, this._mode);
            cpcfg.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String java_home = System.getProperty("java.home");
        if (java_home != null) {
            File jdk_home = null;
            try {
                jdk_home = new File(java_home).getParentFile().getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (jdk_home != null) {
                File tools_jar_file = null;
                try {
                    tools_jar_file = new File(jdk_home, "lib" + File.separator + "tools.jar").getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (tools_jar_file != null && tools_jar_file.isFile()) {
                    _classpath.addComponent(tools_jar_file);
                    if (this._debug) {
                        System.err.println("JAVAC = " + tools_jar_file);
                    }
                }
            }
        }
        System.setProperty("java.class.path", _classpath.toString());
        if (this._debug) {
            System.err.println("CLASSPATH=" + _classpath.toString());
        }
        return _classpath;
    }

    public void shutdown() {
        BrokerPool.stopAll((boolean)false);
    }
}

