/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.excel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import net.sf.flatpack.DataSet;

public class ExcelTransformer {
    private final DataSet ds;
    private final File xlsFile;
    private String[] exportOnlyColumns;
    private String[] excludeFromExportColumns;
    private String[] numericColumns;

    public ExcelTransformer(DataSet ds, File xlsFile) {
        this.ds = ds;
        this.xlsFile = xlsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExcelFile() throws IOException, WriteException {
        WritableWorkbook excelWrkBook = null;
        int curDsPointer = 0;
        try {
            String[] columnNames = this.ds.getColumns();
            List<String> exportOnlyColumnsList = this.getExportOnlyColumns() != null ? Arrays.asList(this.exportOnlyColumns) : null;
            List<String> excludeFromExportColumnsList = this.getExcludeFromExportColumns() != null ? Arrays.asList(this.excludeFromExportColumns) : null;
            List<Object> numericColumnList = this.getNumericColumns() != null ? Arrays.asList(this.getNumericColumns()) : new ArrayList();
            curDsPointer = this.ds.getIndex();
            this.ds.goTop();
            excelWrkBook = Workbook.createWorkbook((File)this.xlsFile);
            WritableSheet wrkSheet = excelWrkBook.createSheet("results", 0);
            WritableFont times10ptBold = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD);
            WritableFont times10pt = new WritableFont(WritableFont.TIMES, 10, WritableFont.NO_BOLD);
            WritableCellFormat cellFormat = new WritableCellFormat(times10ptBold);
            int colOffset = 0;
            for (int i = 0; i < columnNames.length; ++i) {
                if (exportOnlyColumnsList != null && !exportOnlyColumnsList.contains(columnNames[i]) || excludeFromExportColumnsList != null && excludeFromExportColumnsList.contains(columnNames[i])) {
                    ++colOffset;
                    continue;
                }
                Label xlsTextLbl = new Label(i - colOffset, 0, columnNames[i], (CellFormat)cellFormat);
                wrkSheet.addCell((WritableCell)xlsTextLbl);
            }
            cellFormat = new WritableCellFormat(times10pt);
            int row = 1;
            while (this.ds.next()) {
                if (!this.ds.isRecordID("detail")) continue;
                colOffset = 0;
                for (int i = 0; i < columnNames.length; ++i) {
                    if (exportOnlyColumnsList != null && !exportOnlyColumnsList.contains(columnNames[i]) || excludeFromExportColumnsList != null && excludeFromExportColumnsList.contains(columnNames[i])) {
                        ++colOffset;
                        continue;
                    }
                    Object wc = null;
                    wc = numericColumnList.contains(columnNames[i]) ? new Number(i - colOffset, row, this.ds.getDouble(columnNames[i]), (CellFormat)cellFormat) : new Label(i - colOffset, row, this.ds.getString(columnNames[i]), (CellFormat)cellFormat);
                    wrkSheet.addCell((WritableCell)wc);
                }
                ++row;
            }
            excelWrkBook.write();
        }
        finally {
            if (curDsPointer > -1) {
                this.ds.absolute(curDsPointer);
            }
            if (excelWrkBook != null) {
                excelWrkBook.close();
            }
        }
    }

    public void setExcludeFromExportColumns(String[] excludeFromExportColumns) {
        this.excludeFromExportColumns = excludeFromExportColumns != null ? (String[])excludeFromExportColumns.clone() : null;
    }

    public void setExportOnlyColumns(String[] exportOnlyColumns) {
        this.exportOnlyColumns = exportOnlyColumns != null ? (String[])exportOnlyColumns.clone() : null;
    }

    public String[] getNumericColumns() {
        return this.numericColumns;
    }

    public void setNumericColumns(String[] numericColumns) {
        this.numericColumns = numericColumns;
    }

    public String[] getExportOnlyColumns() {
        return this.exportOnlyColumns;
    }

    public String[] getExcludeFromExportColumns() {
        return this.excludeFromExportColumns;
    }
}

