/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartPlot;

public class JRBaseMultiAxisPlot
extends JRBaseChartPlot
implements JRMultiAxisPlot {
    private static final long serialVersionUID = 10200L;
    protected List<JRChartAxis> axes = new ArrayList<JRChartAxis>();

    public JRBaseMultiAxisPlot(JRChartPlot multiAxisPlot, JRChart chart) {
        super(multiAxisPlot, chart);
    }

    public JRBaseMultiAxisPlot(JRMultiAxisPlot multiAxisPlot, ChartsBaseObjectFactory factory) {
        super((JRChartPlot)multiAxisPlot, factory);
        List<JRChartAxis> origAxes = multiAxisPlot.getAxes();
        this.axes.clear();
        if (origAxes != null) {
            for (JRChartAxis axis : origAxes) {
                this.axes.add(factory.getChartAxis(axis));
            }
        }
    }

    @Override
    public List<JRChartAxis> getAxes() {
        return this.axes;
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        for (JRChartAxis axis : this.axes) {
            collector.collect(axis.getChart());
        }
    }

    @Override
    public Object clone(JRChart parentChart) {
        ArrayList<JRChartAxis> cloneAxes;
        JRBaseMultiAxisPlot clone = (JRBaseMultiAxisPlot)super.clone(parentChart);
        if (this.axes == null) {
            cloneAxes = null;
        } else {
            cloneAxes = new ArrayList<JRChartAxis>(this.axes.size());
            for (JRChartAxis axis : this.axes) {
                JRChartAxis axisClone = axis == null ? null : axis.clone(clone);
                cloneAxes.add(axisClone);
            }
        }
        clone.axes = cloneAxes;
        return clone;
    }
}

