/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBasePieDataset
extends JRBaseChartDataset
implements JRPieDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_PERCENTAGE = "minPercentage";
    public static final String PROPERTY_MAX_COUNT = "maxCount";
    private Float minPercentage;
    private Integer maxCount;
    protected JRPieSeries[] pieSeries;
    protected JRExpression otherKeyExpression;
    protected JRExpression otherLabelExpression;
    private JRHyperlink otherSectionHyperlink;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBasePieDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBasePieDataset(JRPieDataset dataset, ChartsBaseObjectFactory factory) {
        super(dataset, factory);
        JRBaseObjectFactory parentFactory = factory.getParent();
        this.minPercentage = dataset.getMinPercentage();
        this.maxCount = dataset.getMaxCount();
        JRPieSeries[] srcPieSeries = dataset.getSeries();
        if (srcPieSeries != null && srcPieSeries.length > 0) {
            this.pieSeries = new JRPieSeries[srcPieSeries.length];
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i] = factory.getPieSeries(srcPieSeries[i]);
            }
        }
        this.otherKeyExpression = parentFactory.getExpression(dataset.getOtherKeyExpression());
        this.otherLabelExpression = parentFactory.getExpression(dataset.getOtherLabelExpression());
        this.otherSectionHyperlink = parentFactory.getHyperlink(dataset.getOtherSectionHyperlink());
    }

    @Override
    public Float getMinPercentage() {
        return this.minPercentage;
    }

    @Override
    public void setMinPercentage(Float minPercentage) {
        Float old = this.minPercentage;
        this.minPercentage = minPercentage;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_PERCENTAGE, (Object)old, (Object)this.minPercentage);
    }

    @Override
    public Integer getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void setMaxCount(Integer maxCount) {
        Integer old = this.maxCount;
        this.maxCount = maxCount;
        this.getEventSupport().firePropertyChange(PROPERTY_MAX_COUNT, (Object)old, (Object)this.maxCount);
    }

    @Override
    public JRPieSeries[] getSeries() {
        return this.pieSeries;
    }

    @Override
    public JRExpression getOtherKeyExpression() {
        return this.otherKeyExpression;
    }

    @Override
    public JRExpression getOtherLabelExpression() {
        return this.otherLabelExpression;
    }

    @Override
    public JRHyperlink getOtherSectionHyperlink() {
        return this.otherSectionHyperlink;
    }

    @Override
    public byte getDatasetType() {
        return 1;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRBasePieDataset clone = (JRBasePieDataset)super.clone();
        clone.pieSeries = (JRPieSeries[])JRCloneUtils.cloneArray((JRCloneable[])this.pieSeries);
        clone.otherKeyExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.otherKeyExpression);
        clone.otherLabelExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.otherLabelExpression);
        clone.otherSectionHyperlink = (JRHyperlink)JRCloneUtils.nullSafeClone((JRCloneable)this.otherSectionHyperlink);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePieDataset jRBasePieDataset = this;
        synchronized (jRBasePieDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }
}

