/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartPlot;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseThermometerPlot
extends JRBaseChartPlot
implements JRThermometerPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange;
    protected JRValueDisplay valueDisplay;
    protected ValueLocationEnum valueLocationObject;
    protected Color mercuryColor;
    protected JRDataRange lowRange;
    protected JRDataRange mediumRange;
    protected JRDataRange highRange;

    public JRBaseThermometerPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
        JRThermometerPlot thermoPlot = plot instanceof JRThermometerPlot ? (JRThermometerPlot)plot : null;
        this.valueDisplay = thermoPlot == null ? new JRBaseValueDisplay(null, chart) : new JRBaseValueDisplay(thermoPlot.getValueDisplay(), chart);
    }

    public JRBaseThermometerPlot(JRThermometerPlot thermoPlot, ChartsBaseObjectFactory factory) {
        super((JRChartPlot)thermoPlot, factory);
        this.dataRange = new JRBaseDataRange(thermoPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(thermoPlot.getValueDisplay(), factory);
        this.valueLocationObject = thermoPlot.getValueLocation();
        this.mercuryColor = thermoPlot.getMercuryColor();
        if (thermoPlot.getLowRange() != null) {
            this.lowRange = new JRBaseDataRange(thermoPlot.getLowRange(), factory);
        }
        if (thermoPlot.getMediumRange() != null) {
            this.mediumRange = new JRBaseDataRange(thermoPlot.getMediumRange(), factory);
        }
        if (thermoPlot.getHighRange() != null) {
            this.highRange = new JRBaseDataRange(thermoPlot.getHighRange(), factory);
        }
    }

    @Override
    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    @Override
    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    @Override
    public ValueLocationEnum getValueLocation() {
        return this.valueLocationObject;
    }

    @Override
    public Color getMercuryColor() {
        return this.mercuryColor;
    }

    @Override
    public JRDataRange getLowRange() {
        return this.lowRange;
    }

    @Override
    public JRDataRange getMediumRange() {
        return this.mediumRange;
    }

    @Override
    public JRDataRange getHighRange() {
        return this.highRange;
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBaseThermometerPlot clone = (JRBaseThermometerPlot)super.clone(parentChart);
        clone.dataRange = (JRDataRange)JRCloneUtils.nullSafeClone((JRCloneable)this.dataRange);
        clone.valueDisplay = this.valueDisplay == null ? null : this.valueDisplay.clone(parentChart);
        clone.lowRange = (JRDataRange)JRCloneUtils.nullSafeClone((JRCloneable)this.lowRange);
        clone.mediumRange = (JRDataRange)JRCloneUtils.nullSafeClone((JRCloneable)this.mediumRange);
        clone.highRange = (JRDataRange)JRCloneUtils.nullSafeClone((JRCloneable)this.highRange);
        return clone;
    }
}

