/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;

public class JRDesignGanttDataset
extends JRDesignChartDataset
implements JRGanttDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_GANTT_SERIES = "ganttSeries";
    private List<JRGanttSeries> ganttSeriesList = new ArrayList<JRGanttSeries>();

    @JsonCreator
    private JRDesignGanttDataset() {
        this(null);
    }

    public JRDesignGanttDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRGanttSeries[] getSeries() {
        JRGanttSeries[] ganttSeriesArray = new JRGanttSeries[this.ganttSeriesList.size()];
        this.ganttSeriesList.toArray(ganttSeriesArray);
        return ganttSeriesArray;
    }

    @JsonIgnore
    public List<JRGanttSeries> getSeriesList() {
        return this.ganttSeriesList;
    }

    @JsonSetter
    private void setSeries(List<JRGanttSeries> series) {
        if (series != null) {
            for (JRGanttSeries s : series) {
                this.addGanttSeries(s);
            }
        }
    }

    public void addGanttSeries(JRGanttSeries ganttSeries) {
        this.ganttSeriesList.add(ganttSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GANTT_SERIES, (Object)ganttSeries, this.ganttSeriesList.size() - 1);
    }

    public void addGanttSeries(int index, JRGanttSeries ganttSeries) {
        this.ganttSeriesList.add(index, ganttSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_GANTT_SERIES, (Object)ganttSeries, index);
    }

    public JRGanttSeries removeGanttSeries(JRGanttSeries ganttSeries) {
        int idx;
        if (ganttSeries != null && (idx = this.ganttSeriesList.indexOf(ganttSeries)) >= 0) {
            this.ganttSeriesList.remove(ganttSeries);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_GANTT_SERIES, (Object)ganttSeries, idx);
        }
        return ganttSeries;
    }

    @Override
    public byte getDatasetType() {
        return 9;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }
}

