/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.fill.ChartsFillObjectFactory;
import net.sf.jasperreports.charts.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultHighLowDataset;

public class JRFillHighLowDataset
extends JRFillChartDataset
implements JRHighLowDataset {
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_CLOSE_VALUE = "charts.high.low.dataset.series.null.close.value";
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_DATE_VALUE = "charts.high.low.dataset.series.null.date.value";
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_HIGH_VALUE = "charts.high.low.dataset.series.null.high.value";
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_LOW_VALUE = "charts.high.low.dataset.series.null.low.value";
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_OPEN_VALUE = "charts.high.low.dataset.series.null.open.value";
    public static final String EXCEPTION_MESSAGE_KEY_SERIES_NULL_VOLUME_VALUE = "charts.high.low.dataset.series.null.volume.value";
    private String series;
    private List<HighLowElement> elements = new ArrayList<HighLowElement>();
    private Date date;
    private Number high;
    private Number low;
    private Number open;
    private Number close;
    private Number volume;
    private JRPrintHyperlink itemHyperlink;
    private List<JRPrintHyperlink> itemHyperlinks;

    public JRFillHighLowDataset(JRHighLowDataset dataset, ChartsFillObjectFactory factory) {
        super(dataset, factory.getParent());
    }

    protected void customInitialize() {
        this.elements = new ArrayList<HighLowElement>();
        this.itemHyperlinks = new ArrayList<JRPrintHyperlink>();
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        this.series = (String)calculator.evaluate(this.getSeriesExpression());
        this.date = (Date)calculator.evaluate(this.getDateExpression());
        this.high = (Number)calculator.evaluate(this.getHighExpression());
        this.low = (Number)calculator.evaluate(this.getLowExpression());
        this.open = (Number)calculator.evaluate(this.getOpenExpression());
        this.close = (Number)calculator.evaluate(this.getCloseExpression());
        this.volume = (Number)calculator.evaluate(this.getVolumeExpression());
        if (this.hasItemHyperlink()) {
            this.evaluateSectionHyperlink(calculator);
        }
    }

    protected void evaluateSectionHyperlink(JRCalculator calculator) throws JRExpressionEvalException {
        try {
            this.itemHyperlink = JRFillHyperlinkHelper.evaluateHyperlink((JRHyperlink)this.getItemHyperlink(), (JRFillExpressionEvaluator)calculator, (byte)3);
        }
        catch (JRExpressionEvalException e) {
            throw e;
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected void customIncrement() {
        this.elements.add(new HighLowElement(this.date, this.high, this.low, this.open, this.close, this.volume));
        if (this.hasItemHyperlink()) {
            this.itemHyperlinks.add(this.itemHyperlink);
        }
    }

    @Override
    public Dataset getCustomDataset() {
        int size = this.elements.size();
        if (size > 0) {
            Date[] dateArray = new Date[size];
            double[] highArray = new double[size];
            double[] lowArray = new double[size];
            double[] openArray = new double[size];
            double[] closeArray = new double[size];
            double[] volumeArray = new double[size];
            for (int i = 0; i < this.elements.size(); ++i) {
                HighLowElement bean = this.elements.get(i);
                dateArray[i] = new Date(bean.getDate().getTime());
                highArray[i] = bean.getHigh().doubleValue();
                lowArray[i] = bean.getLow().doubleValue();
                openArray[i] = bean.getOpen().doubleValue();
                closeArray[i] = bean.getClose().doubleValue();
                volumeArray[i] = bean.getVolume().doubleValue();
            }
            return new DefaultHighLowDataset((Comparable)((Object)this.series), dateArray, highArray, lowArray, openArray, closeArray, volumeArray);
        }
        return null;
    }

    @Override
    public Object getLabelGenerator() {
        return null;
    }

    @Override
    public JRExpression getSeriesExpression() {
        return ((JRHighLowDataset)this.parent).getSeriesExpression();
    }

    @Override
    public JRExpression getDateExpression() {
        return ((JRHighLowDataset)this.parent).getDateExpression();
    }

    @Override
    public JRExpression getHighExpression() {
        return ((JRHighLowDataset)this.parent).getHighExpression();
    }

    @Override
    public JRExpression getLowExpression() {
        return ((JRHighLowDataset)this.parent).getLowExpression();
    }

    @Override
    public JRExpression getOpenExpression() {
        return ((JRHighLowDataset)this.parent).getOpenExpression();
    }

    @Override
    public JRExpression getCloseExpression() {
        return ((JRHighLowDataset)this.parent).getCloseExpression();
    }

    @Override
    public JRExpression getVolumeExpression() {
        return ((JRHighLowDataset)this.parent).getVolumeExpression();
    }

    @Override
    public byte getDatasetType() {
        return 7;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public JRHyperlink getItemHyperlink() {
        return ((JRHighLowDataset)this.parent).getItemHyperlink();
    }

    public boolean hasItemHyperlink() {
        return !JRHyperlinkHelper.isEmpty((JRHyperlink)this.getItemHyperlink());
    }

    public List<JRPrintHyperlink> getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    private static class HighLowElement {
        Date date;
        Number high;
        Number low;
        Number open;
        Number close;
        Number volume;

        public HighLowElement(Date date, Number high, Number low, Number open, Number close, Number volume) {
            if (date == null) {
                throw new JRRuntimeException(JRFillHighLowDataset.EXCEPTION_MESSAGE_KEY_SERIES_NULL_DATE_VALUE, (Object[])null);
            }
            this.date = date;
            if (high == null) {
                throw new JRRuntimeException(JRFillHighLowDataset.EXCEPTION_MESSAGE_KEY_SERIES_NULL_HIGH_VALUE, (Object[])null);
            }
            this.high = high;
            if (low == null) {
                throw new JRRuntimeException(JRFillHighLowDataset.EXCEPTION_MESSAGE_KEY_SERIES_NULL_LOW_VALUE, (Object[])null);
            }
            this.low = low;
            if (open == null) {
                throw new JRRuntimeException(JRFillHighLowDataset.EXCEPTION_MESSAGE_KEY_SERIES_NULL_OPEN_VALUE, (Object[])null);
            }
            this.open = open;
            if (close == null) {
                throw new JRRuntimeException(JRFillHighLowDataset.EXCEPTION_MESSAGE_KEY_SERIES_NULL_CLOSE_VALUE, (Object[])null);
            }
            this.close = close;
            if (volume == null) {
                throw new JRRuntimeException(JRFillHighLowDataset.EXCEPTION_MESSAGE_KEY_SERIES_NULL_VOLUME_VALUE, (Object[])null);
            }
            this.volume = volume;
        }

        public Date getDate() {
            return this.date;
        }

        public Number getHigh() {
            return this.high;
        }

        public Number getLow() {
            return this.low;
        }

        public Number getOpen() {
            return this.open;
        }

        public Number getClose() {
            return this.close;
        }

        public Number getVolume() {
            return this.volume;
        }
    }
}

