/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.poi.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.poi.export.JRXlsExporter;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.SaveContributorFactory;

public class JRMultipleSheetsXlsSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_XLS = ".xls";

    public JRMultipleSheetsXlsSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public JRMultipleSheetsXlsSaveContributor(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
        super(jasperReportsContext, locale, resBundle);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_XLS);
    }

    public String getDescription() {
        return this.getBundleString("file.desc.xls.multiple.sheets");
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_XLS)) {
            file = new File(file.getAbsolutePath() + EXTENSION_XLS);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRXlsExporter exporter = new JRXlsExporter(this.getJasperReportsContext());
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
            SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
            configuration.setOnePagePerSheet(Boolean.valueOf(true));
            exporter.setConfiguration((ReportExportConfiguration)configuration);
            exporter.exportReport();
        }
    }

    public static class Factory
    implements SaveContributorFactory {
        public JRSaveContributor create(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
            return new JRMultipleSheetsXlsSaveContributor(jasperReportsContext, locale, resBundle);
        }
    }
}

