/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.sf.jcc.model.parser.InternalStore;
import net.sf.jcc.model.parser.ParsedElement;
import net.sf.jcc.model.parser.UnexpectedException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class ParseContext {
    private ParseContext root;
    private ParseContext parent;
    private ParsedElement parsedElement;
    private InternalStore<?> internalStore;
    private Deque<String> actionNames;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public ParseContext(ParseContext parent, ParsedElement parsedElement) {
        this.parent = parent;
        this.root = parent == null ? this : parent.root;
        this.parsedElement = parsedElement;
        this.actionNames = new ArrayDeque<String>();
    }

    public ParsedElement getParsedElement() {
        return this.parsedElement;
    }

    public ParseContext getParent() {
        return this.parent;
    }

    public void setInternalStore(InternalStore<?> internalStore) {
        if (this.root.internalStore != null) {
            throw new UnexpectedException("An InternalStore has already been configured for this ParseContext.");
        }
        this.root.internalStore = internalStore;
    }

    public InternalStore<?> getInternalStore() {
        return this.root.internalStore;
    }

    public void addGlobalVariable(String name, Object variable) {
        this.root.variables.put(name, variable);
    }

    public void addVariable(String name, Object variable) {
        this.variables.put(name, variable);
    }

    public boolean containsVariable(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        if (this != this.root && this.root.containsVariable(name)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsVariable(name);
        }
        return false;
    }

    public Object getLocalVariable(String name) {
        return this.variables.get(name);
    }

    public Object getVariable(String name) {
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (this != this.root && this.root.containsVariable(name)) {
            return this.root.getVariable(name);
        }
        if (this.parent != null) {
            return this.parent.getVariable(name);
        }
        return null;
    }

    public String popActionName() {
        if (this.root.actionNames.isEmpty()) {
            return null;
        }
        return this.root.actionNames.pop();
    }

    public void pushActionName(String currentActionName) {
        if (currentActionName == null) {
            return;
        }
        this.root.actionNames.push(currentActionName);
    }

    public Deque<String> getActionNames() {
        return this.root.actionNames;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.parent);
        builder.append((Object)this.parsedElement);
        builder.append(this.internalStore);
        builder.append(this.variables);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParseContext other = (ParseContext)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.parent, (Object)other.parent);
        builder.append((Object)this.parsedElement, (Object)other.parsedElement);
        builder.append(this.internalStore, other.internalStore);
        builder.append(this.variables, other.variables);
        return builder.isEquals();
    }
}

