/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser;

import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.jcc.model.parser.ElementName;
import net.sf.jcc.model.parser.ParsedElement;
import org.apache.commons.lang.builder.ToStringBuilder;

public class XMLParsedElement
implements ParsedElement {
    private final StartElement element;
    private final ElementName elementName;
    private final String elementText;

    public XMLParsedElement(StartElement element, XMLEvent nextEvent) {
        assert (element != null);
        this.element = element;
        this.elementName = new ElementName(element.getName().getNamespaceURI(), element.getName().getLocalPart());
        this.elementText = this.getElementText(nextEvent);
    }

    @Override
    public ElementName getName() {
        return this.elementName;
    }

    @Override
    public String getText() {
        return this.elementText;
    }

    @Override
    public String getAttributeText(ElementName elementName) {
        String value = null;
        Attribute attribute = this.element.getAttributeByName(new QName(elementName.getNamespace(), elementName.getName()));
        QName name = this.element.getName();
        if (attribute == null && name != null && name.getNamespaceURI() != null && name.getNamespaceURI().equals(elementName.getNamespace())) {
            attribute = this.element.getAttributeByName(new QName(null, elementName.getName()));
        }
        if (attribute != null) {
            value = attribute.getValue();
        }
        return value;
    }

    private String getElementText(XMLEvent nextEvent) {
        if (nextEvent != null && nextEvent.isCharacters() && !nextEvent.asCharacters().isWhiteSpace()) {
            String data = nextEvent.asCharacters().getData();
            if (data != null) {
                data = data.trim();
            }
            return data;
        }
        return null;
    }

    public StartElement getElement() {
        return this.element;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append((Object)this.elementName);
        builder.append((Object)this.elementText);
        return builder.toString();
    }
}

