/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ElementHandlerException;
import net.sf.jcc.model.parser.InternalStore;
import net.sf.jcc.model.parser.InternalStoreFactory;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.TransformationRegistry;
import net.sf.jcc.model.parser.TransformationResult;
import net.sf.jcc.model.parser.UnexpectedException;
import net.sf.jcc.model.parser.XMLParseContext;

public class XmlParser {
    private final TransformationRegistry transformationRegistry;
    private final XMLInputFactory xmlInputFactory;
    private final InternalStoreFactory internalStoreFactory;

    public XmlParser(TransformationRegistry transformationRegistry, XMLInputFactory xmlInputFactory, InternalStoreFactory internalStoreFactory) {
        this.transformationRegistry = transformationRegistry;
        this.xmlInputFactory = xmlInputFactory;
        this.internalStoreFactory = internalStoreFactory;
    }

    public void parse(InputStream inputStream, Map<String, Object> initialProperties, TransformationResult transformResult) {
        assert (inputStream != null);
        try {
            this.transform(inputStream, initialProperties, transformResult);
        }
        catch (XMLStreamException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(InputStream inputStream, Map<String, Object> initialProperties, TransformationResult transformResult) throws XMLStreamException {
        XMLParseContext parseContext = null;
        XMLEventReader eventReader = this.xmlInputFactory.createXMLEventReader(inputStream);
        try {
            LinkedHashMap<String, Exception> errorMap = new LinkedHashMap<String, Exception>();
            ElementHandler handler = this.obtainRootOfHandledNodes(eventReader);
            StartElement event = eventReader.nextEvent().asStartElement();
            parseContext = this.createParseContext(eventReader, event, initialProperties);
            this.handleElement(event, handler, parseContext, errorMap);
            this.handleChildren(event.getName(), parseContext, eventReader, false, errorMap);
            this.obtainTransformationResult(parseContext, transformResult);
            this.ensureThereAreNoMoreElementsToHandle(eventReader);
            for (Map.Entry errorEntry : errorMap.entrySet()) {
                System.err.println("Failed to handle event " + errorEntry.getValue() + " : " + (String)errorEntry.getKey());
            }
            if (!errorMap.isEmpty()) {
                throw new UnexpectedException("[" + errorMap.size() + "] Errors occured while handling elements. Refer to the log file for details.");
            }
            this.close(eventReader);
            this.close(parseContext);
        }
        catch (Throwable throwable) {
            this.close(eventReader);
            this.close(parseContext);
            throw throwable;
        }
    }

    private void handleElement(XMLEvent event, ElementHandler handler, XMLParseContext parseContext, Map<String, Exception> errorMap) {
        try {
            handler.handleElement(parseContext);
        }
        catch (ElementHandlerException e) {
            errorMap.put(this.getPathStringForParseContext(parseContext), e);
        }
        catch (RuntimeException e) {
            errorMap.put(this.getPathStringForParseContext(parseContext), e);
        }
    }

    private String getPathStringForParseContext(XMLParseContext parseContext) {
        StringBuilder sb = new StringBuilder();
        String seperator = "";
        for (ParseContext curContext = parseContext; curContext != null; curContext = curContext.getParent()) {
            sb.insert(0, curContext.getParsedElement().getName() + seperator);
            seperator = ":";
        }
        String parseContextPath = sb.toString();
        return parseContextPath;
    }

    private void obtainTransformationResult(ParseContext parseContext, TransformationResult transformationResult) {
        InternalStore<?> internalStore = parseContext.getInternalStore();
        if (internalStore == null) {
            throw new UnexpectedException("Could not obtain Internal Store");
        }
        internalStore.export(transformationResult);
    }

    private ElementHandler obtainRootOfHandledNodes(XMLEventReader eventReader) throws XMLStreamException {
        ElementHandler handler = this.obtainNextElementHandler(eventReader);
        if (handler == null) {
            throw new UnexpectedException("No elements were handled.");
        }
        return handler;
    }

    private void ensureThereAreNoMoreElementsToHandle(XMLEventReader eventReader) throws XMLStreamException {
        if (this.obtainNextElementHandler(eventReader) != null) {
            throw new UnexpectedException("Multiple elements were handled.");
        }
    }

    private ElementHandler obtainNextElementHandler(XMLEventReader eventReader) throws XMLStreamException {
        while (eventReader.hasNext()) {
            XMLParseContext parseContext;
            ElementHandler handler;
            XMLEvent event = eventReader.peek();
            if (event.isStartElement() && (handler = this.transformationRegistry.lookupElementHandler(parseContext = this.createParseContext(eventReader, event))) != null) {
                return handler;
            }
            eventReader.nextEvent();
        }
        return null;
    }

    private void handleChildren(QName parentName, XMLParseContext parentContext, XMLEventReader eventReader, boolean skipElement, Map<String, Exception> errorMap) throws XMLStreamException {
        while (eventReader.hasNext()) {
            QName qName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                ElementHandler handler;
                XMLParseContext childParseContext = this.createParseContext(parentContext, eventReader, event);
                ElementHandler elementHandler = handler = skipElement ? null : this.transformationRegistry.lookupElementHandler(childParseContext);
                if (handler != null) {
                    childParseContext.pushActionName(handler.getName());
                    this.handleElement(event, handler, childParseContext, errorMap);
                    this.handleChildren(event.asStartElement().getName(), childParseContext, eventReader, false, errorMap);
                    childParseContext.popActionName();
                    continue;
                }
                if (!skipElement) {
                    // empty if block
                }
                this.handleChildren(event.asStartElement().getName(), childParseContext, eventReader, true, errorMap);
                continue;
            }
            if (!event.isEndElement() || !(qName = event.asEndElement().getName()).equals(parentName)) continue;
            break;
        }
    }

    private XMLParseContext createParseContext(XMLEventReader eventReader, StartElement event, Map<String, Object> initialProperties) {
        XMLParseContext context = this.createParseContext(eventReader, event);
        if (initialProperties != null) {
            for (Map.Entry<String, Object> entry : initialProperties.entrySet()) {
                context.addGlobalVariable(entry.getKey(), entry.getValue());
            }
        }
        context.setInternalStore((InternalStore<?>)this.internalStoreFactory.createInternalStore());
        return context;
    }

    private XMLParseContext createParseContext(XMLEventReader eventReader, XMLEvent event) {
        return this.createParseContext(null, eventReader, event);
    }

    private XMLParseContext createParseContext(ParseContext parentContext, XMLEventReader eventReader, XMLEvent event) {
        XMLParseContext context = new XMLParseContext(parentContext, event.asStartElement(), eventReader);
        return context;
    }

    private void close(XMLEventReader eventReader) {
        try {
            eventReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void close(ParseContext parseContext) {
        if (parseContext != null && parseContext.getInternalStore() != null) {
            parseContext.getInternalStore().close();
        }
    }
}

