/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser.uml2;

import au.com.sparxsystems.AggregationType;
import au.com.sparxsystems.Association;
import au.com.sparxsystems.AssociationProperties;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ElementHandlerException;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.XMLParseContext;
import net.sf.jcc.model.parser.XMLParsedElement;
import net.sf.jcc.model.parser.uml2.ElementStore;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.xml.namespace.QNameEditor;

public class ConnectorHandler
implements ElementHandler {
    private static final String IDREF_PREFIX = "EAID_";
    private static final String STYLE_SOURCE_ATTRIBUTE_PREFIX = "LFSP={";
    private static final String STYLE_TARGET_ATTRIBUTE_PREFIX = "LFEP={";
    private String sourceClassId;
    private String sourceAttributeId;
    private String targetClassId;
    private String targetAttributeId;
    private String sourceAggregationType;
    private String targetAggregationType;
    private AssociationProperties properties;
    private Association sourceAssociation;
    private Association targetAssociation;
    private static final Logger log = LoggerFactory.getLogger(ConnectorHandler.class);
    private static String[] ignore = new String[]{"ea_type", "isOrdered", "changeable"};

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handleElement(ParseContext parseContext) throws ElementHandlerException {
        this.sourceClassId = null;
        this.sourceAttributeId = null;
        this.targetClassId = null;
        this.targetAttributeId = null;
        this.sourceAssociation = new Association();
        this.targetAssociation = new Association();
        XMLParsedElement pElement = (XMLParsedElement)parseContext.getParsedElement();
        StartElement element = pElement.getElement();
        this.handleChildElements(element.getName(), ((XMLParseContext)parseContext).getEventReader());
        this.assignAssociationsToElement((ElementStore)parseContext.getInternalStore());
    }

    private void assignAssociationsToElement(ElementStore store) {
        String sourceModelElementId = this.sourceAttributeId != null ? this.sourceAttributeId : this.sourceClassId;
        ModelElement sourceModelElement = store.get(sourceModelElementId);
        this.sourceAssociation.setTargetClassId(this.targetClassId);
        this.sourceAssociation.setTargetAttributeId(this.targetAttributeId);
        this.sourceAssociation.setAggregrationType(this.sourceAggregationType == null ? null : AggregationType.fromValue(this.sourceAggregationType));
        this.sourceAssociation.setProperties(this.properties);
        if (sourceModelElement != null) {
            sourceModelElement.addAssocation(this.sourceAssociation);
        }
        String targetModelElementId = this.targetAttributeId != null ? this.targetAttributeId : this.targetClassId;
        this.targetAssociation.setTargetClassId(this.sourceClassId);
        this.targetAssociation.setTargetAttributeId(this.sourceAttributeId);
        this.targetAssociation.setAggregrationType(this.targetAggregationType == null ? null : AggregationType.fromValue(this.targetAggregationType));
        ModelElement targetModelElement = store.get(targetModelElementId);
        if (targetModelElement != null) {
            targetModelElement.addAssocation(this.targetAssociation);
        }
    }

    private void handleChildElements(QName parentName, XMLEventReader eventReader) {
        while (eventReader.hasNext()) {
            try {
                QName qName;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    this.parseStyleToAssociation(event.asStartElement());
                    this.parseSourceElement(event.asStartElement());
                    this.parseTargetElement(event.asStartElement());
                    this.parseTypeElement(event.asStartElement(), parentName);
                    this.parseProperties(event.asStartElement());
                    this.parseModifiers(event.asStartElement(), parentName);
                    this.handleChildElements(event.asStartElement().getName(), eventReader);
                    continue;
                }
                if (!event.isEndElement() || !(qName = event.asEndElement().getName()).equals(parentName)) continue;
                return;
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseProperties(StartElement element) {
        if (element == null || !ELEMENT_TYPE.properties.toString().equals(element.getName().toString())) {
            return;
        }
        this.properties = new AssociationProperties();
        this.assignProperties(this.properties, element.asStartElement());
    }

    private void parseModifiers(StartElement element, QName parentName) {
        if (element == null || !ELEMENT_TYPE.modifiers.toString().equals(element.getName().toString())) {
            return;
        }
        if (ELEMENT_TYPE.source.toString().equals(parentName.toString())) {
            this.assignProperties(this.sourceAssociation, element.asStartElement());
        } else if (ELEMENT_TYPE.target.toString().equals(parentName.toString())) {
            this.assignProperties(this.targetAssociation, element.asStartElement());
        }
    }

    private void parseStyleToAssociation(StartElement element) {
        if (element == null || !ELEMENT_TYPE.style.toString().equals(element.getName().toString())) {
            return;
        }
        Attribute attr = element.getAttributeByName(new QName("", PROPERTY_TYPE.value.toString()));
        String value = attr == null ? null : attr.getValue();
        String targetModelGuid = this.extractTargetModelGuid(value);
        String targetAttributeIdRef = this.transformModelGuidToIdRef(targetModelGuid);
        String sourceModelGuid = this.extractSourceModelGuid(value);
        String sourceAttributeIdRef = this.transformModelGuidToIdRef(sourceModelGuid);
        if (targetAttributeIdRef != null) {
            this.targetAttributeId = targetAttributeIdRef;
        }
        if (sourceAttributeIdRef != null) {
            this.sourceAttributeId = sourceAttributeIdRef;
        }
    }

    private void parseSourceElement(StartElement element) {
        if (element != null && ELEMENT_TYPE.source.toString().equals(element.getName().toString())) {
            this.sourceClassId = this.getIdrefAttributeValue(element);
        }
    }

    private void parseTargetElement(StartElement element) {
        if (element != null && ELEMENT_TYPE.target.toString().equals(element.getName().toString())) {
            this.targetClassId = this.getIdrefAttributeValue(element);
        }
    }

    private void parseTypeElement(StartElement element, QName parentName) {
        if (element != null && ELEMENT_TYPE.type.toString().equals(element.getName().toString())) {
            if (ELEMENT_TYPE.source.toString().equals(parentName.toString())) {
                this.sourceAggregationType = this.getAggregationValue(element);
            } else if (ELEMENT_TYPE.target.toString().equals(parentName.toString())) {
                this.targetAggregationType = this.getAggregationValue(element);
            }
        }
    }

    private String getIdrefAttributeValue(StartElement element) {
        Attribute attr = element.getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", PROPERTY_TYPE.idref.toString()));
        return attr.getValue();
    }

    private String getAggregationValue(StartElement element) {
        Attribute attr = element.getAttributeByName(new QName(PROPERTY_TYPE.aggregation.toString()));
        return attr.getValue();
    }

    protected String extractTargetModelGuid(String styleString) {
        String targetModelGuid = StringUtils.substringBetween((String)styleString, (String)STYLE_TARGET_ATTRIBUTE_PREFIX, (String)"}");
        return targetModelGuid;
    }

    protected String extractSourceModelGuid(String styleString) {
        String sourceModelGuid = StringUtils.substringBetween((String)styleString, (String)STYLE_SOURCE_ATTRIBUTE_PREFIX, (String)"}");
        return sourceModelGuid;
    }

    protected String transformModelGuidToIdRef(String modelGuid) {
        if (modelGuid == null || "".equals(modelGuid)) {
            return null;
        }
        String idRef = IDREF_PREFIX;
        return idRef.concat(StringUtils.replace((String)modelGuid, (String)"-", (String)"_"));
    }

    private void assignProperties(Object e, StartElement element) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(e);
        wrapper.registerCustomEditor(QName.class, (PropertyEditor)new QNameEditor());
        Iterator<Attribute> itr = element.getAttributes();
        while (itr.hasNext()) {
            PropertyDescriptor pd;
            Attribute attribute = itr.next();
            String name = attribute.getName().getLocalPart();
            if (ArrayUtils.contains((Object[])ignore, (Object)name)) continue;
            Object value = attribute.getValue();
            Class attributeClass = BeanUtils.findPropertyType((String)name, (Class[])new Class[]{e.getClass()});
            if (attributeClass.isEnum()) {
                Method method = BeanUtils.findDeclaredMethodWithMinimalParameters((Class)attributeClass, (String)"fromValue");
                try {
                    value = method.invoke(null, value);
                }
                catch (IllegalArgumentException e1) {
                    log.error("IllegalArgumentException trying to invoke fromValue");
                    return;
                }
                catch (IllegalAccessException e1) {
                    log.error("IllegalAccessException trying to invoke fromValue");
                    return;
                }
                catch (InvocationTargetException e1) {
                    log.error("InvocationTargetException trying to invoke fromValue");
                    return;
                }
            }
            if ((pd = BeanUtils.getPropertyDescriptor(e.getClass(), (String)name)) == null) {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd1 : pds = BeanUtils.getPropertyDescriptors(e.getClass())) {
                    if (!pd1.getName().equalsIgnoreCase(name)) continue;
                    name = pd1.getDisplayName();
                    break;
                }
            }
            try {
                wrapper.setPropertyValue(name, value);
            }
            catch (Exception ex) {
                log.info("Error writing property value:" + name + " " + e.getClass().getName());
            }
        }
    }

    private static enum ELEMENT_TYPE {
        style,
        source,
        target,
        type,
        properties,
        modifiers;

    }

    private static enum PROPERTY_TYPE {
        value,
        idref,
        aggregation;

    }
}

