/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser.uml2;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ElementHandlerException;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.XMLParsedElement;
import net.sf.jcc.model.parser.uml2.ElementStore;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.xml.namespace.QNameEditor;

public class ExtensionHandler
implements ElementHandler {
    public static final String PARENT = "ext.parent";
    private static final Logger log = LoggerFactory.getLogger(ExtensionHandler.class);
    private Map<String, Class<?>> elementMap;
    private static String[] ignore = new String[0];

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handleElement(ParseContext parseContext) throws ElementHandlerException {
        QName thisElementName;
        String classname;
        XMLParsedElement pElement = (XMLParsedElement)parseContext.getParsedElement();
        StartElement element = pElement.getElement();
        boolean containedInParent = false;
        Class<?> umlClass = null;
        ParseContext parentContext = parseContext.getParent();
        Object parent = null;
        if (parentContext != null && (parent = parentContext.getLocalVariable(PARENT)) != null && (classname = this.findClassOfAttribute(parent, (thisElementName = element.getName()).getLocalPart())) != null) {
            try {
                umlClass = Class.forName(classname);
                containedInParent = true;
            }
            catch (ClassNotFoundException e) {
                log.error("Class not found:" + classname);
                return;
            }
        }
        if (umlClass == null && (umlClass = this.elementMap.get(element.getName().toString())) == null) {
            log.debug("Class mapping not found:" + element.getName().toString());
            return;
        }
        try {
            ModelElement original;
            Object e = umlClass.newInstance();
            this.assignProperties(e, element);
            if (containedInParent) {
                this.assignToParent(parent, element.getName().getLocalPart(), e);
            } else if (parentContext != null) {
                QName thisElementName2 = element.getName();
                String parentName = parentContext.getParsedElement().getName().getName();
                if (parentName.startsWith(thisElementName2.getLocalPart()) && (parent = parentContext.getVariable(PARENT)) != null) {
                    this.assignToParent(parent, parentName, e);
                }
            }
            parseContext.addVariable(PARENT, e);
            ElementStore store = (ElementStore)parseContext.getInternalStore();
            Attribute attr = element.getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "idref"));
            if (attr != null && (original = store.get(attr.getValue())) != null) {
                original.setExtension(e);
            }
        }
        catch (InstantiationException e) {
            log.error("Class not instantiated:" + umlClass.getName());
        }
        catch (IllegalAccessException e) {
            log.error("Illegal Access:" + umlClass.getName());
        }
    }

    private void assignToParent(Object target, String name, Object value) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(target);
        try {
            Object descendant = wrapper.getPropertyValue(name);
            if (descendant instanceof List) {
                List list = (List)descendant;
                list.add(value);
                return;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            wrapper.setPropertyValue(name, value);
        }
        catch (Exception ex) {
            log.info("Error writing property value:" + name + " " + target.getClass().getName());
        }
    }

    protected String findClassOfAttribute(Object target, String name) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(target.getClass(), (String)name);
        if (pd == null) {
            return null;
        }
        return pd.getReadMethod().getReturnType().getName();
    }

    private void assignProperties(Object e, StartElement element) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(e);
        wrapper.registerCustomEditor(QName.class, (PropertyEditor)new QNameEditor());
        Iterator<Attribute> itr = element.getAttributes();
        while (itr.hasNext()) {
            PropertyDescriptor pd;
            Attribute attribute = itr.next();
            String name = attribute.getName().getLocalPart();
            if (ArrayUtils.contains((Object[])ignore, (Object)name)) continue;
            Object value = attribute.getValue();
            Class attributeClass = BeanUtils.findPropertyType((String)name, (Class[])new Class[]{e.getClass()});
            if (attributeClass.isEnum()) {
                Method method = BeanUtils.findDeclaredMethodWithMinimalParameters((Class)attributeClass, (String)"fromValue");
                try {
                    value = method.invoke(null, value);
                }
                catch (IllegalArgumentException e1) {
                    log.error("IllegalArgumentException trying to invoke fromValue");
                    return;
                }
                catch (IllegalAccessException e1) {
                    log.error("IllegalAccessException trying to invoke fromValue");
                    return;
                }
                catch (InvocationTargetException e1) {
                    log.error("InvocationTargetException trying to invoke fromValue");
                    return;
                }
            }
            if ((pd = BeanUtils.getPropertyDescriptor(e.getClass(), (String)name)) == null) {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd1 : pds = BeanUtils.getPropertyDescriptors(e.getClass())) {
                    if (!pd1.getName().equalsIgnoreCase(name)) continue;
                    name = pd1.getDisplayName();
                    break;
                }
            }
            try {
                if (name != null && name.startsWith("ea_")) {
                    name = name.replaceFirst("ea_", "");
                }
                wrapper.setPropertyValue(name, value);
            }
            catch (Exception ex) {
                log.info("Error writing property value:" + name + " " + e.getClass().getName());
            }
        }
    }

    public Map<String, Class<?>> getElementMap() {
        return this.elementMap;
    }

    public void setElementMap(Map<String, Class<?>> elementMap) {
        this.elementMap = elementMap;
    }
}

