/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser.uml2;

import au.com.sparxsystems.Association;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class ModelElement {
    private String guid;
    private Object element;
    private Object extension;
    private Map<QName, List<String>> references;
    private List<Association> associations;
    private String parentGuid;

    public ModelElement(String guid, Object element) {
        this.guid = guid;
        this.element = element;
        this.references = new HashMap<QName, List<String>>();
    }

    public String getGuid() {
        return this.guid;
    }

    public Object getElement() {
        return this.element;
    }

    public void addReference(QName name, String ref) {
        List<String> refs = this.references.get(name);
        if (refs == null) {
            refs = new ArrayList<String>();
            this.references.put(name, refs);
        }
        refs.add(ref);
    }

    public Iterator<QName> references() {
        return this.references.keySet().iterator();
    }

    public String getReference(QName qname) {
        List<String> refs = this.references.get(qname);
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        return refs.get(0);
    }

    public List<String> getReferences(QName qname) {
        return this.references.get(qname);
    }

    public Object getExtension() {
        return this.extension;
    }

    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    public void setAssociations(List<Association> associations) {
        this.associations = associations;
    }

    public void addAssocation(Association association) {
        if (this.associations == null) {
            this.associations = new ArrayList<Association>();
        }
        this.associations.add(association);
    }

    public String getParentGuid() {
        return this.parentGuid;
    }

    public void setParentGuid(String parentGuid) {
        this.parentGuid = parentGuid;
    }
}

