/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcc.model.parser.uml2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.jcc.model.parser.ElementHandler;
import net.sf.jcc.model.parser.ElementHandlerException;
import net.sf.jcc.model.parser.InternalStore;
import net.sf.jcc.model.parser.ParseContext;
import net.sf.jcc.model.parser.UnexpectedException;
import net.sf.jcc.model.parser.XMLParsedElement;
import net.sf.jcc.model.parser.uml2.ModelElement;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;

public class PackagedElementHandler
implements ElementHandler {
    public static final String PARENT = "parent";
    private static String[] ignore = new String[]{"id", "type", "supplier"};

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void handleElement(ParseContext parseContext) throws ElementHandlerException {
        XMLParsedElement pElement = (XMLParsedElement)parseContext.getParsedElement();
        StartElement element = pElement.getElement();
        Attribute attr = element.getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "type"));
        String type = attr.getValue();
        String[] split = type.split(":");
        if (!split[0].equals("uml")) {
            throw new UnexpectedException("Invalid type namespace:" + split[0]);
        }
        try {
            Class<?> umlClass = Class.forName("org.omg.uml." + split[1]);
            Object e = umlClass.newInstance();
            InternalStore<?> store = parseContext.getInternalStore();
            attr = element.getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "id"));
            String guid = attr.getValue();
            this.assignProperties(e, element);
            ModelElement modelElement = new ModelElement(guid, e);
            store.store(modelElement);
            parseContext.addVariable(PARENT, modelElement);
            this.relateToParent(element, parseContext, e);
            this.relateParentToElement(parseContext, modelElement);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private <T> void relateToParent(StartElement element, ParseContext parseContext, T e) {
        String elementName = element.getName().getLocalPart();
        ParseContext parentContext = parseContext.getParent();
        if (parentContext == null) {
            return;
        }
        ModelElement modelElement = (ModelElement)parentContext.getLocalVariable(PARENT);
        if (modelElement == null) {
            return;
        }
        Object parent = modelElement.getElement();
        BeanWrapperImpl wrapper = new BeanWrapperImpl(parent);
        try {
            Class attributeClass = BeanUtils.findPropertyType((String)elementName, (Class[])new Class[]{parent.getClass()});
            if (Collection.class.isAssignableFrom(attributeClass)) {
                Collection collection = (Collection)wrapper.getPropertyValue(elementName);
                collection.add(e);
            } else {
                wrapper.setPropertyValue(elementName, e);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void assignProperties(Object e, StartElement element) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(e);
        Iterator<Attribute> itr = element.getAttributes();
        while (itr.hasNext()) {
            Attribute attribute = itr.next();
            String name = attribute.getName().getLocalPart();
            if (ArrayUtils.contains((Object[])ignore, (Object)name)) continue;
            Object value = attribute.getValue();
            Class attributeClass = BeanUtils.findPropertyType((String)name, (Class[])new Class[]{e.getClass()});
            if (attributeClass.isEnum()) {
                Method method = BeanUtils.findDeclaredMethodWithMinimalParameters((Class)attributeClass, (String)"fromValue");
                try {
                    value = method.invoke(null, value);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            if (Collection.class.isAssignableFrom(attributeClass)) {
                Collection collection = (Collection)wrapper.getPropertyValue(name);
                collection.add(value);
                continue;
            }
            try {
                wrapper.setPropertyValue(name, value);
            }
            catch (NotWritablePropertyException e1) {}
        }
    }

    private void relateParentToElement(ParseContext parseContext, ModelElement modelElement) {
        if (parseContext.getParent() == null) {
            return;
        }
        XMLParsedElement parentParsedElement = (XMLParsedElement)parseContext.getParent().getParsedElement();
        Attribute parentAttribute = parentParsedElement.getElement().getAttributeByName(new QName("http://schema.omg.org/spec/XMI/2.1", "id"));
        modelElement.setParentGuid(parentAttribute == null ? null : parentAttribute.getValue());
    }
}

