/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.sf.sahi.util.CaseInsensitiveString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders {
    LinkedHashMap<CaseInsensitiveString, List<String>> headers = new LinkedHashMap(15);

    public void addHeader(String key, String value) {
        CaseInsensitiveString keyIgnoreCase = new CaseInsensitiveString(key);
        List<String> entry = this.headers.get(keyIgnoreCase);
        if (entry == null) {
            entry = new ArrayList<String>();
            this.headers.put(keyIgnoreCase, entry);
        }
        entry.add(value);
    }

    public void setHeader(String key, String value) {
        CaseInsensitiveString keyIgnoreCase = new CaseInsensitiveString(key);
        ArrayList<String> entry = new ArrayList<String>();
        entry.add(value);
        this.headers.put(keyIgnoreCase, entry);
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(new CaseInsensitiveString(key));
    }

    public String getHeader(String key) {
        CaseInsensitiveString keyIgnoreCase = new CaseInsensitiveString(key);
        List<String> values = this.headers.get(keyIgnoreCase);
        if (values == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            String value = values.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public List<String> getHeaders(String key) {
        CaseInsensitiveString keyIgnoreCase = new CaseInsensitiveString(key);
        return this.headers.get(keyIgnoreCase);
    }

    public void addHeaders(String key, List<String> newHeaders) {
        if (newHeaders == null) {
            return;
        }
        CaseInsensitiveString keyIgnoreCase = new CaseInsensitiveString(key);
        List<String> entry = this.headers.get(keyIgnoreCase);
        if (entry == null) {
            entry = new ArrayList<String>();
            this.headers.put(keyIgnoreCase, entry);
        }
        entry.addAll(newHeaders);
    }

    public String getLastHeader(String key) {
        List<String> entry = this.headers.get(new CaseInsensitiveString(key));
        if (entry == null) {
            return null;
        }
        return entry.get(entry.size() - 1);
    }

    public byte[] getBytes() {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (CaseInsensitiveString key : this.headers.keySet()) {
            if (key.isNull()) continue;
            List<String> values = this.headers.get(key);
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                String value = values.get(i);
                sb.append(key).append(": ").append(value).append("\r\n");
            }
        }
        return sb.toString();
    }

    public void removeHeader(String key) {
        this.headers.remove(new CaseInsensitiveString(key));
    }

    public Set<CaseInsensitiveString> keySet() {
        return this.headers.keySet();
    }

    public Iterator<String> keysIterator() {
        return new HttpHeadersIterator(this.keySet().iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpHeadersIterator
    implements Iterator<String> {
        private Iterator<CaseInsensitiveString> iterator;

        public HttpHeadersIterator(Iterator<CaseInsensitiveString> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().toString();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

