/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.sahi.ProxyProcessor;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.util.BrowserTypesLoader;
import net.sf.sahi.util.Diagnostics;
import net.sf.sahi.util.Utils;

public class Proxy {
    static Proxy currentInstance;
    private int port = 9999;
    private ServerSocket server;
    private ExecutorService pool;
    private boolean forceClosed;

    public Proxy(int port) {
        this.port = port;
    }

    public Proxy() {
        this.port = Configuration.getPort();
    }

    public static void main(String[] args) {
        Proxy proxy;
        if (args.length > 0) {
            Configuration.init(args[0], args[1]);
        } else {
            Configuration.init();
        }
        currentInstance = proxy = new Proxy(Configuration.getPort());
        proxy.start(false);
    }

    public static void stopCurrentIntance() {
        currentInstance.stop();
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.forceClosed = true;
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void start(boolean asynch) {
        if (!asynch) {
            try {
                this.startProxy();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            Proxy.this.startProxy();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        return this.server != null && !this.server.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startProxy() throws IOException {
        try {
            byte[] probe = Utils.readURL("http://localhost:" + Configuration.getPort() + "/_s_/spr/probe.htm", false);
            if (probe != null) {
                System.out.println("---");
                System.out.println("--- ERROR: Port " + Configuration.getPort() + " is already being used ---");
                System.out.println("---");
                return;
            }
            this.server = new ServerSocket();
            this.pool = Executors.newCachedThreadPool();
            this.server.setReuseAddress(true);
            this.server.bind(new InetSocketAddress(this.port), 300);
            System.out.println(">>>> Sahi started. Listening on port: " + this.port);
            System.out.println(">>>> Configure your browser to use this server and port as its proxy");
            System.out.println(">>>> Browse any page and CTRL-ALT-DblClick on the page to bring up the Sahi Controller");
            BrowserTypesLoader.getAvailableBrowserTypes(true);
            new Thread(new Diagnostics()).start();
            while (!this.forceClosed && !this.server.isClosed()) {
                try {
                    Socket client = this.server.accept();
                    this.pool.execute(new ProxyProcessor(client));
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.server != null) {
                this.server.close();
            }
        }
    }
}

