/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import net.sf.sahi.LocalRequestProcessor;
import net.sf.sahi.RemoteRequestProcessor;
import net.sf.sahi.command.MockResponder;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.ssl.SSLHelper;
import net.sf.sahi.util.ThreadLocalMap;
import net.sf.sahi.util.TrafficLogger;
import net.sf.sahi.util.Utils;

public class ProxyProcessor
implements Runnable {
    private Socket client;
    private boolean isSSLSocket = false;
    private static Logger logger = Configuration.getLogger("net.sf.sahi.ProxyProcessor");
    public RemoteRequestProcessor remoteRequestProcessor = new RemoteRequestProcessor();
    private static HashMap<String, String> hostAddresses = new HashMap(100);
    private static String localhost;

    public ProxyProcessor(Socket client) {
        this.client = client;
        this.isSSLSocket = client instanceof SSLSocket;
    }

    public void run() {
        if (this.client.isClosed()) {
            return;
        }
        ThreadLocalMap.clearAll();
        HttpRequest requestFromBrowser = null;
        try {
            requestFromBrowser = this.getRequestFromBrowser();
            String uri = requestFromBrowser.uri();
            logger.finest(uri);
            if (uri != null) {
                int _s_ = uri.indexOf("/_s_/");
                int q = uri.indexOf("?");
                if (_s_ != -1 && (q == -1 || q > _s_)) {
                    this.processLocally(uri, requestFromBrowser);
                } else if (this.isHostTheProxy(requestFromBrowser.host()) && requestFromBrowser.port() == Configuration.getPort()) {
                    this.processLocally(uri, requestFromBrowser);
                } else if (uri.indexOf("favicon.ico") != -1) {
                    this.sendResponseToBrowser(new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/favicon.ico"));
                } else {
                    this.processAsProxy(requestFromBrowser);
                }
            } else {
                this.sendResponseToBrowser(new SimpleHttpResponse(""));
            }
            if (this.isKeepAlive() && !this.client.isClosed()) {
                new Thread(new ProxyProcessor(this.client)).start();
            }
        }
        catch (SSLHandshakeException ssle) {
            logger.fine(ssle.getMessage());
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
            try {
                this.client.close();
            }
            catch (IOException e2) {
                logger.warning(e2.getMessage());
            }
        }
    }

    private boolean isHostTheProxy(String host) {
        try {
            if (host.equals(Configuration.getCommonDomain())) {
                return true;
            }
            String hostAddress = this.getHostAddress(host);
            return hostAddress.equals(localhost) || hostAddress.equals("127.0.0.1");
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getHostAddress(String host) throws UnknownHostException {
        if (!hostAddresses.containsKey(host)) {
            hostAddresses.put(host, InetAddress.getByName(host).getHostAddress());
        }
        return hostAddresses.get(host);
    }

    private void processAsProxy(HttpRequest requestFromBrowser) throws Exception {
        String fileName = requestFromBrowser.fileName();
        Date time = new Date();
        TrafficLogger.createLoggerForThread(fileName, "unmodified", Configuration.isUnmodifiedTrafficLoggingOn(), time);
        TrafficLogger.createLoggerForThread(fileName, "modified", Configuration.isModifiedTrafficLoggingOn(), time);
        if (requestFromBrowser.isConnect()) {
            this.processConnect(requestFromBrowser);
        } else {
            if (this.handleDifferently(requestFromBrowser)) {
                return;
            }
            HttpResponse responseFromHost = null;
            try {
                responseFromHost = this.remoteRequestProcessor.processHttp(requestFromBrowser);
            }
            catch (Exception e) {
                e.printStackTrace();
                responseFromHost = new SimpleHttpResponse("");
            }
            if (responseFromHost == null) {
                responseFromHost = new SimpleHttpResponse("");
            }
            this.sendResponseToBrowser(responseFromHost);
        }
    }

    private boolean handleDifferently(HttpRequest request) throws Exception {
        MockResponder mockResponder = request.session().mockResponder();
        HttpResponse response = mockResponder.getResponse(request);
        if (response == null) {
            return false;
        }
        this.sendResponseToBrowser(response);
        return true;
    }

    private void processConnect(HttpRequest requestFromBrowser) {
        try {
            this.client.getOutputStream().write("HTTP/1.0 200 OK\r\n\r\n".getBytes());
            SSLSocket sslSocket = new SSLHelper().convertToSecureServerSocket(this.client, requestFromBrowser.host());
            ProxyProcessor delegatedProcessor = new ProxyProcessor(sslSocket);
            delegatedProcessor.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processLocally(String uri, HttpRequest requestFromBrowser) throws IOException {
        HttpResponse httpResponse;
        try {
            httpResponse = new LocalRequestProcessor().getLocalResponse(uri, requestFromBrowser);
        }
        catch (Exception e) {
            Properties props = new Properties();
            props.put("responseCode", "500");
            props.put("time", "" + new Date());
            props.put("message", Utils.getStackTraceString(e, true));
            httpResponse = new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/5xx.htm", props, false, true);
        }
        this.sendResponseToBrowser(httpResponse);
    }

    private HttpRequest getRequestFromBrowser() throws IOException {
        InputStream in = this.client.getInputStream();
        return new HttpRequest(in, this.isSSLSocket);
    }

    protected void sendResponseToBrowser(HttpResponse responseFromHost) throws IOException {
        OutputStream outputStreamToBrowser = this.client.getOutputStream();
        responseFromHost.sendHeaders(outputStreamToBrowser, this.isKeepAlive());
        responseFromHost.sendBody(outputStreamToBrowser);
        if (!this.isKeepAlive()) {
            outputStreamToBrowser.close();
            this.client.close();
        }
        responseFromHost.cleanUp();
    }

    private boolean isKeepAlive() {
        return Configuration.isKeepAliveEnabled() && !this.isSSLSocket;
    }

    protected Socket client() {
        return this.client;
    }

    static {
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

