/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.sahi.HttpHeaders;
import net.sf.sahi.util.Utils;

public abstract class StreamHandler {
    HttpHeaders headers = new HttpHeaders();
    private byte[] rawHeaders;
    private int contentLength = -1;
    private byte[] data;
    protected String firstLine;

    protected void populateData(InputStream in) throws IOException {
        this.data = Utils.getBytes(in, this.contentLength());
        this.setContentLength(this.data.length);
    }

    protected void populateHeaders(InputStream in, boolean handleFirstLineSpecially) throws IOException {
        this.setRawHeaders(in);
        this.setHeaders(new String(this.rawHeaders), handleFirstLineSpecially);
        this.setContentLengthFromHeader();
    }

    protected void setContentLength(int length) {
        this.removeHeader("Content-Length");
        if (length != -1) {
            this.setHeader("Content-Length", "" + length);
        }
        this.contentLength = length;
    }

    private void setContentLengthFromHeader() {
        String contentLenStr = this.getLastSetValueOfHeader("Content-Length");
        if (contentLenStr != null) {
            this.contentLength = Integer.parseInt(contentLenStr);
        }
    }

    public byte[] data() {
        return this.data;
    }

    public byte[] setData(byte[] bytes) {
        this.data = bytes;
        this.setContentLength(bytes.length);
        this.resetRawHeaders();
        return this.data;
    }

    public final int contentLength() {
        return this.contentLength;
    }

    public final HttpHeaders headers() {
        return this.headers;
    }

    public boolean hasHeader(String key) {
        return this.headers.hasHeader(key);
    }

    public final byte[] rawHeaders() {
        return this.rawHeaders;
    }

    public byte[] setRawHeaders(byte[] bytes) {
        this.rawHeaders = bytes;
        return bytes;
    }

    public void resetRawHeaders() {
        this.setRawHeaders(this.getRebuiltHeaderBytes());
    }

    private void setRawHeaders(InputStream in) throws IOException {
        byte c;
        StringBuilder sb = new StringBuilder();
        int prev = 32;
        while ((c = (byte)in.read()) != -1) {
            sb.append((char)c);
            if (c == 13 && prev == 10) {
                sb.append((char)in.read());
                break;
            }
            prev = c;
        }
        this.rawHeaders = sb.toString().getBytes();
    }

    private void setHeaders(String s, boolean handleFirstLineSpecially) {
        StringTokenizer tokenizer = new StringTokenizer(s, "\r\n");
        boolean isFirst = true;
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if ("".equals(line.trim())) continue;
            if (handleFirstLineSpecially && isFirst) {
                this.firstLine = line;
                isFirst = false;
                continue;
            }
            int ix = line.indexOf(":");
            if (ix == -1) continue;
            String key = line.substring(0, ix);
            String value = line.substring(ix + 1).trim();
            this.addHeader(key, value);
        }
    }

    protected final String firstLine() {
        return this.firstLine;
    }

    protected String setFirstLine(String s) {
        this.firstLine = s;
        return this.firstLine;
    }

    protected byte[] getRebuiltHeaderBytes() {
        StringBuilder sb = new StringBuilder();
        if (this.firstLine() != null) {
            sb.append(this.firstLine());
            sb.append("\r\n");
        }
        sb.append(this.headers.toString());
        sb.append("\r\n");
        return sb.toString().getBytes();
    }

    public void setHeader(String key, String value) {
        this.headers.setHeader(key, value);
    }

    public void addHeader(String key, String value) {
        this.headers.addHeader(key, value);
    }

    public void removeHeader(String key) {
        this.headers.removeHeader(key);
    }

    public void removeHeader(String key, String value) {
        List<String> values = this.headers.getHeaders(key);
        if (values == null) {
            return;
        }
        int size = values.size();
        int removeIx = -1;
        for (int i = 0; i < size; ++i) {
            String value2 = values.get(i);
            if (!value.equals(value2)) continue;
            removeIx = i;
        }
        if (removeIx != -1) {
            values.remove(removeIx);
        }
    }

    protected String getLastSetValueOfHeader(String key) {
        return this.headers.getLastHeader(key);
    }

    protected void copyFrom(StreamHandler orig) {
        this.headers = orig.headers;
        this.rawHeaders = orig.rawHeaders;
        this.contentLength = orig.contentLength;
        this.data = orig.data;
        this.firstLine = orig.firstLine;
    }
}

