/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.playback.ScriptUtil;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.rhino.RhinoScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.util.Diagnostics;
import net.sf.sahi.util.Utils;

public class ControllerUI {
    public void opened(HttpRequest request) {
        request.session().setIsWindowOpen(true);
    }

    public void closed(HttpRequest request) {
        request.session().setIsWindowOpen(false);
    }

    public HttpResponse getSahiScript(HttpRequest request) {
        String code = request.getParameter("code");
        return new NoCacheHttpResponse(Utils.encode(SahiScript.modifyFunctionNames(code)));
    }

    public HttpResponse scriptsList(HttpRequest request) {
        return new NoCacheHttpResponse(ScriptUtil.getScriptsJs(this.getScriptPath(request.session())));
    }

    public HttpResponse scriptDirsList(HttpRequest request) {
        return new NoCacheHttpResponse(ScriptUtil.getScriptRootsJs(request.session().getRecorder().getDir()));
    }

    public HttpResponse scriptDirsListJSON(HttpRequest request) {
        String[] fileList = Configuration.getScriptRoots();
        return new NoCacheHttpResponse(Utils.toJSON(fileList));
    }

    public HttpResponse scriptsListJSON(HttpRequest request) {
        String dir = request.getParameter("dir");
        String[] fileList = ScriptUtil.getScriptFiles(dir);
        return new NoCacheHttpResponse(Utils.toJSON(fileList));
    }

    private String getScriptPath(Session session) {
        RhinoScriptRunner scriptRunner = (RhinoScriptRunner)session.getScriptRunner();
        if (scriptRunner == null) {
            return "";
        }
        SahiScript script = scriptRunner.getScript();
        if (script == null) {
            return "";
        }
        return Utils.escapeDoubleQuotesAndBackSlashes(script.getFilePath());
    }

    public HttpResponse getOSInfo(HttpRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append("osname_$sahi$_:" + System.getProperty("os.name") + "_$sahi$_;");
        sb.append("osversion_$sahi$_:" + System.getProperty("os.version") + "_$sahi$_;");
        sb.append("osarch_$sahi$_:" + System.getProperty("os.arch") + "_$sahi$_;");
        sb.append("istasklistavailable_$sahi$_:" + Diagnostics.TASKLIST_STATUS);
        return new SimpleHttpResponse(sb.toString());
    }

    public HttpResponse getJavaInfo(HttpRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append("javadir_$sahi$_:" + System.getProperty("java.home") + "_$sahi$_;");
        sb.append("javaversion_$sahi$_:" + System.getProperty("java.version") + "_$sahi$_;");
        sb.append("iskeytoolavailable_$sahi$_:" + Diagnostics.KEYTOOL_STATUS);
        return new SimpleHttpResponse(sb.toString());
    }

    public HttpResponse getChangeLog(HttpRequest request) {
        String dataStr = new String(Utils.readFile(Configuration.getChangeLogFilePath()));
        dataStr = dataStr.replace("\r\n", "\n").replace("\r", "\n").replace("\n", "<br/>");
        dataStr = dataStr.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return new NoCacheHttpResponse(dataStr);
    }

    public HttpResponse getSahiVersion(HttpRequest request) {
        return new SimpleHttpResponse(Configuration.getVersion());
    }
}

