/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.util.Properties;
import java.util.logging.Logger;
import net.sf.sahi.command.Player;
import net.sf.sahi.command.StepWiseRecorder;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpModifiedResponse2;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.rhino.ScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.BrowserLauncher;
import net.sf.sahi.util.BrowserType;
import net.sf.sahi.util.BrowserTypesLoader;
import net.sf.sahi.util.ProxySwitcher;
import net.sf.sahi.util.Utils;

public class Driver {
    private static Logger logger = Configuration.getLogger("net.sf.sahi.command.Driver");
    private Boolean useSystemProxy = false;

    public void setControllerMode(HttpRequest request) {
        String mode = request.getParameter("mode");
        Configuration.setControllerMode(mode);
    }

    public void launchAndRecord(HttpRequest request) {
        this.launchBrowser(request);
        this.record(request);
    }

    public void launchAndPlayback(HttpRequest request) {
        this.launchBrowser(request);
    }

    private void launchBrowser(HttpRequest request) {
        String browser = request.getParameter("browser");
        String browserOption = request.getParameter("browserOption");
        String browserProcessName = request.getParameter("browserProcessName");
        this.launch(browser, browserProcessName, browserOption, "true".equals(request.getParameter("useSystemProxy")), request);
    }

    public void launchPreconfiguredBrowser(HttpRequest request) {
        BrowserTypesLoader browserLoader = new BrowserTypesLoader();
        BrowserType browserType = browserLoader.getBrowserType(request);
        if (browserType != null) {
            this.launch(browserType.path(), browserType.processName(), browserType.options(), browserType.useSystemProxy(), request);
        }
    }

    private void launch(String browser, String browserProcessName, String browserOption, boolean useProxy, HttpRequest request) {
        Session session = request.session();
        String startUrl = request.getParameter("startUrl");
        if (startUrl == null) {
            startUrl = "";
        }
        if (useProxy) {
            this.useSystemProxy = true;
            this.enableIEProxy(request);
        }
        BrowserLauncher launcher = new BrowserLauncher(browser, browserProcessName, browserOption);
        String url = "http://" + Configuration.getCommonDomain() + "/_s_/dyn/Driver_start?sahisid=" + session.id() + "&startUrl=" + Utils.encode("http://" + Configuration.getCommonDomain() + "/_s_/dyn/Driver_initialized?startUrl=" + Utils.encode(startUrl));
        launcher.openURL(url);
        session.setLauncher(launcher);
    }

    public void kill(HttpRequest request) {
        Session session = request.session();
        BrowserLauncher launcher = session.getLauncher();
        if (launcher != null) {
            launcher.kill();
            if (this.useSystemProxy.booleanValue()) {
                this.disableIEProxy(request);
            }
        }
    }

    public HttpResponse start(HttpRequest request) {
        Session session = request.session();
        session.setScriptRunner(new ScriptRunner());
        return new Player().autoJava(request);
    }

    public void restart(HttpRequest request) {
        Session session = request.session();
        session.setScriptRunner(new ScriptRunner());
        session.setIsPlaying(true);
        session.setIsReadyForDriver(true);
    }

    public HttpResponse initialized(HttpRequest request) {
        Session session = request.session();
        session.setIsPlaying(true);
        session.setIsReadyForDriver(true);
        String startUrl = request.getParameter("startUrl");
        Properties properties = new Properties();
        if (startUrl == null) {
            startUrl = "";
        }
        properties.setProperty("startUrl", startUrl);
        HttpFileResponse httpFileResponse = new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/initialized.htm", properties, false, true);
        HttpModifiedResponse2 response = new HttpModifiedResponse2(httpFileResponse, false, "htm");
        return response;
    }

    public HttpResponse isReady(HttpRequest request) {
        return new SimpleHttpResponse("" + request.session().isReadyForDriver());
    }

    public void setStep(HttpRequest request) {
        String step = request.getParameter("step");
        this.setStep(request, step);
    }

    public void setBrowserJS(HttpRequest request) {
        Session session = request.session();
        String browserJS = request.getParameter("browserJS");
        session.getScriptRunner().setBrowserJS(browserJS);
    }

    public HttpResponse getVariable(HttpRequest request) {
        String key = request.getParameter("key");
        Session session = request.session();
        String val = session.getVariable(key);
        return new SimpleHttpResponse(val != null ? val : "");
    }

    public HttpResponse doneStep(HttpRequest request) {
        boolean done;
        Session session = request.session();
        ScriptRunner scriptRunner = session.getScriptRunner();
        if (scriptRunner == null) {
            return new SimpleHttpResponse("error:Playback session not started. Verify that proxy is set on the browser.");
        }
        boolean bl = done = scriptRunner.doneStep("") || scriptRunner.isStopped();
        if (done) {
            Status status = scriptRunner.getStatus();
            String browserException = scriptRunner.getBrowserException();
            if (browserException == null) {
                browserException = "";
            }
            if (status == Status.ERROR) {
                return new SimpleHttpResponse("error:" + browserException);
            }
            if (status == Status.FAILURE) {
                return new SimpleHttpResponse("failure:" + browserException);
            }
        }
        return new SimpleHttpResponse("" + done);
    }

    public SimpleHttpResponse getRecordedSteps(HttpRequest request) {
        return new StepWiseRecorder().getSteps(request);
    }

    public void setLastIdentifiedElement(HttpRequest request) {
        Session session = request.session();
        session.setVariable("__sahi__lastIdentifiedElement", request.getParameter("element"));
    }

    public SimpleHttpResponse getLastIdentifiedElement(HttpRequest request) {
        Session session = request.session();
        String val = session.getVariable("__sahi__lastIdentifiedElement");
        session.setVariable("__sahi__lastIdentifiedElement", null);
        return new SimpleHttpResponse(val == null ? "" : val);
    }

    public SimpleHttpResponse getAllRecordedSteps(HttpRequest request) {
        return new StepWiseRecorder().getAllSteps(request);
    }

    public void startRecording(HttpRequest request) {
        this.record(request);
        request.session().setIsWindowOpen(true);
        if (!"true".equals(request.getParameter("fromBrowser"))) {
            this.setStep(request, "_sahi.openController()");
        }
    }

    private void record(HttpRequest request) {
        Session session = request.session();
        session.setIsRecording(true);
        new StepWiseRecorder().start(request);
        session.setIsPlaying(false);
    }

    public void stopRecording(HttpRequest request) {
        new StepWiseRecorder().stop(request);
        Session session = request.session();
        session.setIsWindowOpen(false);
        if (!"true".equals(request.getParameter("fromBrowser"))) {
            this.setStep(request, "_sahi.closeController()");
        }
        session.setIsRecording(false);
        session.setIsPlaying(true);
    }

    public SimpleHttpResponse isRecording(HttpRequest request) {
        return new SimpleHttpResponse("" + request.session().isRecording());
    }

    private void setStep(HttpRequest request, String step) {
        Session session = request.session();
        session.getScriptRunner().setStep(step, "");
    }

    public void setSpeed(HttpRequest request) {
        try {
            String speed = request.getParameter("speed");
            logger.fine("Setting speed to " + speed);
            Configuration.setTimeBetweenSteps(Integer.parseInt(speed));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toggleIEProxy(boolean enable) {
        String cmd = Configuration.getAbsolutePath("tools/toggle_IE_proxy.exe " + (enable ? "enable" : "disable"));
        String[] tokens = Utils.getCommandTokens(cmd.replaceAll("%20", " "));
        try {
            Utils.executeAndGetProcess(tokens);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void enableIEProxy(HttpRequest request) {
        ProxySwitcher.setSahiAsProxy();
    }

    public void disableIEProxy(HttpRequest request) {
        ProxySwitcher.revertSystemProxy();
    }
}

