/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.util.Properties;
import net.sf.sahi.command.Script;
import net.sf.sahi.command.SessionState;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.FileScript;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.playback.ScriptFactory;
import net.sf.sahi.report.LogViewer;
import net.sf.sahi.report.ResultType;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.rhino.RhinoScriptRunner;
import net.sf.sahi.rhino.ScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.ProcessHelper;
import net.sf.sahi.util.Utils;

public class Player {
    public void stepWisePlay(HttpRequest request) {
        this.startPlayback(request.session(), false, "1");
    }

    public void start(HttpRequest request) {
        this.startPlayback(request.session(), true, "1");
    }

    public void stop(HttpRequest request) {
        Session session = request.session();
        if (session.getRecorder() != null) {
            session.getRecorder().stop();
        }
        if (session.getScriptRunner() != null) {
            session.getScriptRunner().stop();
        }
    }

    public void setScriptFile(HttpRequest request) {
        Session session = request.session();
        String dir = request.getParameter("dir");
        String fileName = request.getParameter("file");
        session.setIsWindowOpen("1".equals(request.getParameter("manual")));
        String filePath = Utils.concatPaths(dir, fileName);
        this.setScript(session, filePath);
    }

    public void setScriptUrl(HttpRequest request) {
        Session session = request.session();
        String url = request.getParameter("url");
        session.setIsWindowOpen("1".equals(request.getParameter("manual")));
        this.setScript(session, url);
    }

    public void resetScript(HttpRequest request) {
        Session session = request.session();
        String scriptPath = session.getVariable("sahi_scriptPath");
        this.stop(request);
        this.setScript(session, scriptPath);
    }

    private void setScript(Session session, String scriptPath) {
        SahiScript script = new ScriptFactory().getScript(scriptPath);
        RhinoScriptRunner scriptRunner = new RhinoScriptRunner(script);
        session.setScriptRunner(scriptRunner);
        this.startPlayback(session, true, "1");
    }

    private void startPlayback(Session session, boolean resetConditions, String paused) {
        if (resetConditions) {
            session.removeVariables(".*");
        }
        ScriptRunner scriptRunner = session.getScriptRunner();
        scriptRunner.setStatus(Status.RUNNING);
        session.setIsPlaying(true);
        session.setVariable("sahi_paused", paused);
        session.setVariable("sahi_controller_tab", "playback");
        session.setVariable("sahi_scriptPath", scriptRunner.getScriptFilePath());
        scriptRunner.execute();
    }

    public HttpResponse isPlaying(HttpRequest request) {
        Session session = request.session();
        return new SimpleHttpResponse(session.isPlaying() ? "1" : "0");
    }

    public HttpResponse getCurrentStep(HttpRequest request) {
        Session session = request.session();
        ScriptRunner scriptRunner = session.getScriptRunner();
        if (scriptRunner == null) {
            return new SimpleHttpResponse("{'type':'WAIT'}");
        }
        String derivedName = request.getParameter("derivedName");
        String windowName = request.getParameter("windowName");
        String windowTitle = request.getParameter("windowTitle");
        String domain = request.getParameter("domain");
        String wasOpened = request.getParameter("wasOpened");
        return new SimpleHttpResponse(scriptRunner.getStepJSON(derivedName, windowName, windowTitle, domain, wasOpened));
    }

    public void markStepDone(HttpRequest request) {
        Session session = request.session();
        ScriptRunner scriptRunner = session.getScriptRunner();
        String failureMessage = request.getParameter("failureMsg");
        String type = request.getParameter("type");
        scriptRunner.markStepDone(request.getParameter("stepId"), ResultType.getType(type), failureMessage);
        session.set204(false);
    }

    public HttpResponse check204(HttpRequest request) {
        Session session = request.session();
        return new SimpleHttpResponse("" + session.is204());
    }

    public void markStepInProgress(HttpRequest request) {
        Session session = request.session();
        ScriptRunner scriptRunner = session.getScriptRunner();
        String type = request.getParameter("type");
        scriptRunner.markStepInProgress(request.getParameter("stepId"), ResultType.getType(type));
    }

    public HttpResponse currentScript(HttpRequest request) {
        Session session = request.session();
        SahiScript script = this.getScript(session);
        if (script != null) {
            return new Script().view(script.getFilePath());
        }
        return new SimpleHttpResponse("No Script has been set for playback.");
    }

    private SahiScript getScript(Session session) {
        RhinoScriptRunner scriptRunner = (RhinoScriptRunner)session.getScriptRunner();
        return scriptRunner.getScript();
    }

    public HttpResponse currentBrowserScript(HttpRequest request) {
        Session session = request.session();
        SimpleHttpResponse httpResponse = session.getScriptRunner() != null && this.getScript(session) != null ? new SimpleHttpResponse(LogViewer.highlight(this.getScript(session).getBrowserJS(), -1)) : new SimpleHttpResponse("No Script has been set for playback.");
        return httpResponse;
    }

    public HttpResponse currentParsedScript(HttpRequest request) {
        Session session = request.session();
        SimpleHttpResponse httpResponse = this.getScript(session) != null ? new SimpleHttpResponse("<pre>" + this.getScript(session).modifiedScript().replaceAll("\\\\r", "").replaceAll("\\\\n", "<br>") + "</pre>") : new SimpleHttpResponse("No Script has been set for playback.");
        return httpResponse;
    }

    public HttpResponse script(HttpRequest request) {
        Session session = request.session();
        ScriptRunner scriptRunner = session.getScriptRunner();
        String s = null;
        if (scriptRunner != null) {
            s = scriptRunner.getScript() != null ? scriptRunner.getScript().getBrowserJS() : scriptRunner.getBrowserJS();
        }
        if (s == null) {
            s = "";
        }
        return new NoCacheHttpResponse(s);
    }

    public HttpResponse auto2(HttpRequest request) {
        String fileName;
        ProcessHelper.setProcessStarted();
        Session session = request.session();
        String scriptFileWithPath = fileName = request.getParameter("file");
        RhinoScriptRunner scriptRunner = new RhinoScriptRunner(new FileScript(scriptFileWithPath));
        session.setScriptRunner(scriptRunner);
        session.setIsPlaying(true);
        String startUrl = request.getParameter("startUrl");
        session.setIsWindowOpen(false);
        this.startPlayback(session, true, "0");
        return this.proxyAutoResponse(startUrl, session.id());
    }

    public HttpResponse auto(HttpRequest request) {
        ProcessHelper.setProcessStarted();
        Session session = request.session();
        String startUrl = request.getParameter("startUrl");
        session.setIsWindowOpen(false);
        session.setIsPlaying(true);
        return this.proxyAutoResponse(startUrl, session.id());
    }

    public HttpResponse autoJava(HttpRequest request) {
        ProcessHelper.setProcessStarted();
        Session session = request.session();
        String startUrl = request.getParameter("startUrl");
        session.setIsWindowOpen(false);
        session.removeVariables(".*");
        session.setIsReadyForDriver(false);
        return this.proxyAutoResponse(startUrl, session.id());
    }

    public void setRetries(HttpRequest request) {
        ScriptRunner scriptRunner = request.session().getScriptRunner();
        if (scriptRunner != null) {
            scriptRunner.setBrowserRetries(Integer.parseInt(request.getParameter("retries")));
        }
    }

    public HttpResponse getRetries(HttpRequest request) {
        ScriptRunner scriptRunner = request.session().getScriptRunner();
        return new SimpleHttpResponse(scriptRunner != null ? "" + scriptRunner.getBrowserRetries() : "-1");
    }

    public HttpResponse hasErrors(HttpRequest request) {
        ScriptRunner scriptRunner = request.session().getScriptRunner();
        return new SimpleHttpResponse("" + scriptRunner.hasErrors());
    }

    public void xsuccess(HttpRequest request) {
        Session session = request.session();
        session.touch();
        SessionState state = new SessionState();
        state.setVar("sahi_retries", "0", session);
        state.setVar("sahi_not_my_win_retries", "0", session);
    }

    private HttpResponse proxyAutoResponse(String startUrl, String sessionId) {
        Properties props = new Properties();
        props.setProperty("startUrl", startUrl);
        props.setProperty("sessionId", sessionId);
        return new NoCacheHttpResponse(new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/auto.htm", props, false, true));
    }
}

